/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk;

import java.util.Calendar;
import net.objectlab.kit.datecalc.common.PeriodCountBasis;
import net.objectlab.kit.datecalc.common.PeriodCountCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarPeriodCountCalculator
implements PeriodCountCalculator<Calendar> {
    private static final long MILLIS_IN_DAY = 86400000L;

    public int dayDiff(Calendar start, Calendar end, PeriodCountBasis basis) {
        int diff = 0;
        switch (basis) {
            case CONV_30_360: {
                diff = this.calculateConv30360(start, end);
                break;
            }
            case CONV_360E_ISDA: {
                diff = this.calculateConv360EIsda(start, end);
                break;
            }
            case CONV_360E_ISMA: {
                diff = this.calculateConv360EIsma(start, end);
                break;
            }
            default: {
                diff = this.dayDiff(start, end);
            }
        }
        return diff;
    }

    private int calculateConv360EIsma(Calendar start, Calendar end) {
        int dayStart = start.get(5);
        int dayEnd = end.get(5);
        if (dayEnd == 31) {
            dayEnd = 30;
        }
        if (dayStart == 31) {
            dayStart = 30;
        }
        int diff = (end.get(1) - start.get(1)) * 360 + (end.get(2) - start.get(2)) * 30 + dayEnd - dayStart;
        return diff;
    }

    private int calculateConv360EIsda(Calendar start, Calendar end) {
        if (start.equals(end)) {
            return 0;
        }
        int dayStart = start.get(5);
        int dayEnd = end.get(5);
        if (start.getActualMaximum(5) == dayStart) {
            dayStart = 30;
        }
        if (end.get(2) != 1 && end.getActualMaximum(5) == dayEnd) {
            dayEnd = 30;
        }
        int diff = (end.get(1) - start.get(1)) * 360 + (end.get(2) - start.get(2)) * 30 + dayEnd - dayStart;
        return diff;
    }

    private int calculateConv30360(Calendar start, Calendar end) {
        int dayStart = start.get(5);
        int dayEnd = end.get(5);
        if (dayEnd == 31 && dayStart >= 30) {
            dayEnd = 30;
        }
        if (dayStart == 31) {
            dayStart = 30;
        }
        int diff = (end.get(1) - start.get(1)) * 360 + (end.get(2) - start.get(2)) * 30 + dayEnd - dayStart;
        return diff;
    }

    private int dayDiff(Calendar start, Calendar end) {
        long diff = Math.abs(start.getTimeInMillis() - end.getTimeInMillis());
        double dayDiff = (double)diff / 8.64E7;
        return (int)Math.round(dayDiff);
    }

    public double monthDiff(Calendar start, Calendar end, PeriodCountBasis basis) {
        return this.yearDiff(start, end, basis) * 12.0;
    }

    public double yearDiff(Calendar start, Calendar end, PeriodCountBasis basis) {
        double diff = 0.0;
        switch (basis) {
            case ACT_ACT: {
                int startYear = start.get(1);
                int endYear = end.get(1);
                if (startYear == endYear) break;
                Calendar endOfStartYear = (Calendar)start.clone();
                endOfStartYear.set(6, endOfStartYear.getActualMaximum(6));
                Calendar startOfEndYear = (Calendar)end.clone();
                startOfEndYear.set(6, startOfEndYear.getActualMinimum(6));
                int diff1 = this.dayDiff(start, endOfStartYear);
                int diff2 = this.dayDiff(startOfEndYear, end);
                diff = ((double)diff1 + 1.0) / (double)start.getActualMaximum(6) + ((double)(endYear - startYear) - 1.0) + (double)diff2 / (double)end.getActualMaximum(6);
                break;
            }
            case CONV_30_360: 
            case CONV_360E_ISDA: 
            case CONV_360E_ISMA: 
            case ACT_360: {
                diff = (double)this.dayDiff(start, end, basis) / 360.0;
                break;
            }
            case ACT_365: {
                diff = (double)this.dayDiff(start, end, basis) / 365.0;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Sorry no ACT_UST yet");
            }
        }
        return diff;
    }
}

