/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk;

import java.util.Calendar;
import net.objectlab.kit.datecalc.common.AbstractKitCalculatorsFactory;
import net.objectlab.kit.datecalc.common.CurrencyDateCalculatorBuilder;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.IMMDateCalculator;
import net.objectlab.kit.datecalc.common.PeriodCountCalculator;
import net.objectlab.kit.datecalc.common.SpotLag;
import net.objectlab.kit.datecalc.jdk.CalendarBackwardHandler;
import net.objectlab.kit.datecalc.jdk.CalendarCurrencyDateCalculator;
import net.objectlab.kit.datecalc.jdk.CalendarDateCalculator;
import net.objectlab.kit.datecalc.jdk.CalendarForwardHandler;
import net.objectlab.kit.datecalc.jdk.CalendarForwardUnlessNegativeHandler;
import net.objectlab.kit.datecalc.jdk.CalendarIMMDateCalculator;
import net.objectlab.kit.datecalc.jdk.CalendarModifiedFollowingHandler;
import net.objectlab.kit.datecalc.jdk.CalendarModifiedPrecedingHandler;
import net.objectlab.kit.datecalc.jdk.CalendarPeriodCountCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarKitCalculatorsFactory
extends AbstractKitCalculatorsFactory<Calendar> {
    private static final CalendarKitCalculatorsFactory DEFAULT = new CalendarKitCalculatorsFactory();
    private static final PeriodCountCalculator<Calendar> PCC = new CalendarPeriodCountCalculator();
    private static final CalendarIMMDateCalculator IMMDC = new CalendarIMMDateCalculator();

    public static CalendarKitCalculatorsFactory getDefaultInstance() {
        return DEFAULT;
    }

    public CurrencyDateCalculatorBuilder<Calendar> getDefaultCurrencyDateCalculatorBuilder(String ccy1, String ccy2, SpotLag spotLag) {
        CurrencyDateCalculatorBuilder builder = new CurrencyDateCalculatorBuilder().currencyPair(ccy1, ccy2, spotLag);
        return this.configureCurrencyCalculatorBuilder(builder).tenorHolidayHandler((HolidayHandler)new CalendarModifiedFollowingHandler());
    }

    public static CurrencyDateCalculatorBuilder<Calendar> defaultCurrencyDateCalculatorBuilder(String ccy1, String ccy2, SpotLag spotLag) {
        return DEFAULT.getDefaultCurrencyDateCalculatorBuilder(ccy1, ccy2, spotLag);
    }

    public CalendarCurrencyDateCalculator buildCurrencyDateCalculator(CurrencyDateCalculatorBuilder<Calendar> builder) {
        return new CalendarCurrencyDateCalculator(builder);
    }

    public static CalendarCurrencyDateCalculator forwardCurrencyDateCalculator(String ccy1, String ccy2, SpotLag spotLag) {
        return DEFAULT.getDefaultCurrencyDateCalculator(ccy1, ccy2, spotLag);
    }

    public CalendarCurrencyDateCalculator getDefaultCurrencyDateCalculator(String ccy1, String ccy2, SpotLag spotLag) {
        return new CalendarCurrencyDateCalculator(this.getDefaultCurrencyDateCalculatorBuilder(ccy1, ccy2, spotLag));
    }

    public static CalendarDateCalculator forwardCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "forward");
    }

    public static CalendarDateCalculator backwardCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "backward");
    }

    public static CalendarDateCalculator forwardUnlessMovingBackCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "forwardUnlessMovingBack");
    }

    public static CalendarDateCalculator modifiedFollowingCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "modifiedFollowing");
    }

    public static CalendarDateCalculator modifiedPrecedingCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "modifiedPreceding");
    }

    public CalendarDateCalculator getDateCalculator(String name, String holidayHandlerType) {
        CalendarDateCalculator cal = new CalendarDateCalculator();
        cal.setName(name);
        this.setHolidays(name, (DateCalculator)cal);
        if (holidayHandlerType != null) {
            cal.setHolidayHandler(this.getHolidayHandler(holidayHandlerType));
        }
        return cal;
    }

    public HolidayHandler<Calendar> getHolidayHandler(String holidayHandlerType) {
        if ("forward".equals(holidayHandlerType)) {
            return new CalendarForwardHandler();
        }
        if ("backward".equals(holidayHandlerType)) {
            return new CalendarBackwardHandler();
        }
        if ("modifiedFollowing".equals(holidayHandlerType)) {
            return new CalendarModifiedFollowingHandler();
        }
        if ("modifiedPreceding".equals(holidayHandlerType)) {
            return new CalendarModifiedPrecedingHandler();
        }
        if ("forwardUnlessMovingBack".equals(holidayHandlerType)) {
            return new CalendarForwardUnlessNegativeHandler();
        }
        if (holidayHandlerType != null) {
            throw new IllegalArgumentException("Unsupported HolidayHandler: " + holidayHandlerType);
        }
        return null;
    }

    public PeriodCountCalculator<Calendar> getPeriodCountCalculator() {
        return PCC;
    }

    public IMMDateCalculator<Calendar> getIMMDateCalculator() {
        return IMMDC;
    }
}

