/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.net.URL;
import java.util.StringTokenizer;
import net.noderunner.http.HttpException;
import net.noderunner.http.HttpVersion;
import net.noderunner.http.Method;

public class RequestLine {
    private final Method method;
    private final String requestURI;
    private final HttpVersion version;
    private String toString;

    public RequestLine(Method method, String requestURI) {
        this(method, requestURI, HttpVersion.HTTP11);
    }

    public RequestLine(Method method, String requestURI, HttpVersion version) {
        if (method == null) {
            throw new IllegalArgumentException("Null method");
        }
        if (requestURI == null) {
            throw new IllegalArgumentException("Null requestURI string");
        }
        if (version == null) {
            throw new IllegalArgumentException("Null version");
        }
        this.method = method;
        if (requestURI.length() == 0) {
            requestURI = "/";
        }
        this.requestURI = requestURI;
        this.version = version;
    }

    public RequestLine(String line) throws HttpException {
        StringTokenizer st = new StringTokenizer(line, " ");
        try {
            this.method = Method.valueOf(st.nextToken());
            this.requestURI = st.nextToken();
            this.version = st.hasMoreTokens() ? HttpVersion.parseVersion(st.nextToken()) : HttpVersion.HTTP10;
        }
        catch (RuntimeException e) {
            throw new HttpException("Invalid Request-Line: " + line);
        }
    }

    public RequestLine(RequestLine requestLine, String requestURI) {
        this(requestLine.getMethod(), requestURI, requestLine.getHttpVersion());
    }

    public static RequestLine create(URL url, Method method) {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        if (method == null) {
            throw new IllegalArgumentException("Null method");
        }
        return new RequestLine(method, url.getFile());
    }

    public Method getMethod() {
        return this.method;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public HttpVersion getHttpVersion() {
        return this.version;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = this.getMethod().name() + ' ' + this.getRequestURI() + ' ' + this.getHttpVersion();
        }
        return this.toString;
    }
}

