/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.IOException;
import java.io.InputStream;
import net.noderunner.http.HttpUtil;
import net.noderunner.http.MessageHeader;
import net.noderunner.http.MessageHeaders;
import net.noderunner.http.Response;
import net.noderunner.http.StatusLine;

public class ClientResponse
extends Response {
    private final InputStream is;

    public ClientResponse(InputStream is) throws IOException {
        super(ClientResponse.parse(is), MessageHeaders.readHeaders(is));
        this.is = is;
    }

    private static StatusLine parse(InputStream is) throws IOException {
        String line;
        while ((line = HttpUtil.readHttpLine(is)).length() == 0) {
        }
        return StatusLine.parseStatusLine(line);
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public int readFully() throws IOException {
        boolean close;
        InputStream s = HttpUtil.wrapInputStream(this.getInputStream(), this.getHeaders());
        if (s != null && !(close = this.getHeaders().contains(MessageHeader.MH_CONNECTION_CLOSE))) {
            return HttpUtil.readFully(s);
        }
        return 0;
    }

    public String toString() {
        return super.toString() + " is=" + this.is;
    }
}

