/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.amazon.s3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.noderunner.amazon.s3.Response;
import net.noderunner.amazon.s3.S3Object;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;

public class GetResponse
extends Response {
    private S3Object object;

    GetResponse(HttpMethod method) throws IOException {
        super(method);
        if (this.getResponseCode() < 400) {
            long len = ((HttpMethodBase)method).getResponseContentLength();
            byte[] body = GetResponse.toByteArray(method.getResponseBodyAsStream(), len);
            this.object = new S3Object(body, this.getHeaders().extractMetadata());
        }
    }

    private static byte[] toByteArray(InputStream stream, long len) throws IOException {
        int count;
        int chunkSize = 4096;
        byte[] buf = new byte[4096];
        ByteArrayOutputStream baos = len != -1L ? new ByteArrayOutputStream((int)len) : new ByteArrayOutputStream(4096);
        while ((count = stream.read(buf)) != -1) {
            baos.write(buf, 0, count);
        }
        return baos.toByteArray();
    }

    public S3Object getObject() {
        return this.object;
    }

    public String toString() {
        return super.toString() + " object=" + this.object;
    }
}

