/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.dynamicproxy.util;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.neoremind.dynamicproxy.DefaultProxyCreator;
import net.neoremind.dynamicproxy.ProxyCreator;
import net.neoremind.dynamicproxy.util.Emptys;

public abstract class ProxyUtil {
    public static final Object[] EMPTY_ARGUMENTS = Emptys.EMPTY_OBJECT_ARRAY;
    public static final Class<?>[] EMPTY_ARGUMENT_TYPES = Emptys.EMPTY_CLASS_ARRAY;
    private static final Map<Class<?>, Class<?>> WRAPPER_CLASS_MAP;
    private static final Map<Class<?>, Object> NULL_VALUE_MAP;

    public static String getJavaClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return ProxyUtil.getJavaClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static Class<?> getWrapperClass(Class<?> primitiveType) {
        return WRAPPER_CLASS_MAP.get(primitiveType);
    }

    public static <T> T nullValue(Class<T> type) {
        Object result = NULL_VALUE_MAP.get(type);
        return (T)result;
    }

    public static ProxyCreator getInstance() {
        return DefaultProxyCreator.INSTANCE;
    }

    public static boolean isHashCode(Method method) {
        return "hashCode".equals(method.getName()) && Integer.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 0;
    }

    public static boolean isEqualsMethod(Method method) {
        return "equals".equals(method.getName()) && Boolean.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 1 && Object.class.equals(method.getParameterTypes()[0]);
    }

    static {
        HashMap wrappers = Maps.newHashMapWithExpectedSize((int)8);
        wrappers.put(Integer.TYPE, Integer.class);
        wrappers.put(Character.TYPE, Character.class);
        wrappers.put(Boolean.TYPE, Boolean.class);
        wrappers.put(Short.TYPE, Short.class);
        wrappers.put(Long.TYPE, Long.class);
        wrappers.put(Float.TYPE, Float.class);
        wrappers.put(Double.TYPE, Double.class);
        wrappers.put(Byte.TYPE, Byte.class);
        WRAPPER_CLASS_MAP = Collections.unmodifiableMap(wrappers);
        HashMap nullValues = Maps.newHashMapWithExpectedSize((int)8);
        nullValues.put(Integer.TYPE, 0);
        nullValues.put(Long.TYPE, 0L);
        nullValues.put(Short.TYPE, (short)0);
        nullValues.put(Byte.TYPE, (byte)0);
        nullValues.put(Float.TYPE, Float.valueOf(0.0f));
        nullValues.put(Double.TYPE, 0.0);
        nullValues.put(Character.TYPE, Character.valueOf('\u0000'));
        nullValues.put(Boolean.TYPE, Boolean.FALSE);
        NULL_VALUE_MAP = Collections.unmodifiableMap(nullValues);
    }
}

