/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.dynamicproxy.template;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import net.neoremind.dynamicproxy.exception.ProxyCreatorException;
import net.neoremind.dynamicproxy.template.CreatorTemplate;

public abstract class SubclassCreatorTemplate
extends CreatorTemplate {
    @Override
    public boolean canProxy(Class<?> ... proxyClasses) {
        try {
            SubclassCreatorTemplate.getSuperclass(proxyClasses);
            return true;
        }
        catch (ProxyCreatorException e) {
            return false;
        }
    }

    private static boolean hasDefaultConstructor(Class<?> superclass) {
        Constructor<?>[] declaredConstructors = superclass.getDeclaredConstructors();
        for (int i = 0; i < declaredConstructors.length; ++i) {
            Constructor<?> constructor = declaredConstructors[i];
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers()) && !Modifier.isProtected(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }

    private static Class<?>[] toNonInterfaces(Class<?>[] proxyClasses) {
        LinkedHashSet superclasses = Sets.newLinkedHashSet();
        for (Class<?> proxyClass : proxyClasses) {
            if (proxyClass.isInterface()) continue;
            superclasses.add(proxyClass);
        }
        return superclasses.toArray(new Class[superclasses.size()]);
    }

    protected static Class<?>[] toInterfaces(Class<?>[] proxyClasses) {
        LinkedHashSet interfaces = Sets.newLinkedHashSet();
        for (Class<?> proxyClass : proxyClasses) {
            if (!proxyClass.isInterface()) continue;
            interfaces.add(proxyClass);
        }
        interfaces.add(Serializable.class);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static Class<?> getSuperclass(Class<?>[] proxyClasses) {
        Class<?>[] superclasses = SubclassCreatorTemplate.toNonInterfaces(proxyClasses);
        switch (superclasses.length) {
            case 0: {
                return Object.class;
            }
            case 1: {
                Class<?> superclass = superclasses[0];
                if (Modifier.isFinal(superclass.getModifiers())) {
                    throw new ProxyCreatorException("Proxy class cannot extend " + superclass.getName() + " as it is final.");
                }
                if (!SubclassCreatorTemplate.hasDefaultConstructor(superclass)) {
                    throw new ProxyCreatorException("Proxy class cannot extend " + superclass.getName() + ", because it has no visible default constructor.");
                }
                return superclass;
            }
        }
        StringBuilder errorMessage = new StringBuilder("Proxy class cannot extend ");
        for (int i = 0; i < superclasses.length; ++i) {
            Class<?> c = superclasses[i];
            errorMessage.append(c.getName());
            if (i == superclasses.length - 1) continue;
            errorMessage.append(", ");
        }
        errorMessage.append("; multiple inheritance not allowed.");
        throw new ProxyCreatorException(errorMessage.toString());
    }
}

