/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.dynamicproxy.template;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.neoremind.dynamicproxy.template.ClassGenerator;

public class ClassCache {
    private final Map<ClassLoader, Map<Set<Class<?>>, WeakReference<Class<?>>>> loaderToClassCache = Maps.newHashMap();
    private final ClassGenerator proxyClassGenerator;

    public ClassCache(ClassGenerator proxyClassGenerator) {
        this.proxyClassGenerator = proxyClassGenerator;
    }

    private Map<Set<Class<?>>, WeakReference<Class<?>>> getClassCache(ClassLoader classLoader) {
        HashMap cache = this.loaderToClassCache.get(classLoader);
        if (cache == null) {
            cache = Maps.newHashMap();
            this.loaderToClassCache.put(classLoader, cache);
        }
        return cache;
    }

    private Set<Class<?>> toClassCacheKey(Class<?>[] proxyClasses) {
        return Sets.newHashSet(Arrays.asList(proxyClasses));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Class<?> getProxyClass(ClassLoader classLoader, Class<?>[] proxyClasses) {
        Class<?> proxyClass;
        Set<Class<?>> key;
        Map<Set<Class<?>>, WeakReference<Class<?>>> classCache = this.getClassCache(classLoader);
        Reference proxyClassReference = classCache.get(key = this.toClassCacheKey(proxyClasses));
        if (proxyClassReference == null) {
            proxyClass = this.proxyClassGenerator.generateProxyClass(classLoader, proxyClasses);
            classCache.put(key, new WeakReference<Class>(proxyClass));
        } else {
            Reference reference = proxyClassReference;
            synchronized (reference) {
                proxyClass = (Class<?>)proxyClassReference.get();
                if (proxyClass == null) {
                    proxyClass = this.proxyClassGenerator.generateProxyClass(classLoader, proxyClasses);
                    classCache.put(key, new WeakReference(proxyClass));
                }
            }
        }
        return proxyClass;
    }
}

