/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.dynamicproxy.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import net.neoremind.dynamicproxy.Interceptor;
import net.neoremind.dynamicproxy.Invocation;
import net.neoremind.dynamicproxy.ObjectInvoker;
import net.neoremind.dynamicproxy.ObjectProvider;
import net.neoremind.dynamicproxy.template.SubclassCreatorTemplate;
import net.neoremind.dynamicproxy.util.ObjectUtil;
import net.neoremind.dynamicproxy.util.ProxyUtil;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Dispatcher;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang3.ArrayUtils;

public class CglibCreator
extends SubclassCreatorTemplate {
    private static final CallbackFilter CALLBACK_FILTER = new CglibProxyFactoryCallbackFilter();

    @Override
    public <T> T createDelegatorProxy(ClassLoader classLoader, ObjectProvider<?> targetProvider, Class<?> ... proxyClasses) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classLoader);
        enhancer.setInterfaces((Class[])CglibCreator.toInterfaces(proxyClasses));
        enhancer.setSuperclass(CglibCreator.getSuperclass(proxyClasses));
        enhancer.setCallbackFilter(CALLBACK_FILTER);
        enhancer.setCallbacks(new Callback[]{new ObjectProviderDispatcher(targetProvider), new EqualsHandler(), new HashCodeHandler()});
        Object result = enhancer.create();
        return (T)result;
    }

    @Override
    public <T> T createInterceptorProxy(ClassLoader classLoader, Object target, Interceptor interceptor, Class<?> ... proxyClasses) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classLoader);
        enhancer.setInterfaces((Class[])CglibCreator.toInterfaces(proxyClasses));
        enhancer.setSuperclass(CglibCreator.getSuperclass(proxyClasses));
        enhancer.setCallbackFilter(CALLBACK_FILTER);
        enhancer.setCallbacks(new Callback[]{new InterceptorBridge(target, interceptor), new EqualsHandler(), new HashCodeHandler()});
        Object result = enhancer.create();
        return (T)result;
    }

    @Override
    public <T> T createInvokerProxy(ClassLoader classLoader, ObjectInvoker invoker, Class<?> ... proxyClasses) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classLoader);
        enhancer.setInterfaces((Class[])CglibCreator.toInterfaces(proxyClasses));
        enhancer.setSuperclass(CglibCreator.getSuperclass(proxyClasses));
        enhancer.setCallbackFilter(CALLBACK_FILTER);
        enhancer.setCallbacks(new Callback[]{new InvokerBridge(invoker), new EqualsHandler(), new HashCodeHandler()});
        Object result = enhancer.create();
        return (T)result;
    }

    private static class ObjectProviderDispatcher
    implements Dispatcher,
    Serializable {
        private static final long serialVersionUID = -3709071685921903647L;
        private final ObjectProvider<?> delegateProvider;

        public ObjectProviderDispatcher(ObjectProvider<?> delegateProvider) {
            this.delegateProvider = delegateProvider;
        }

        public Object loadObject() {
            return this.delegateProvider.getObject();
        }
    }

    private static class MethodProxyInvocation
    implements Invocation {
        private final Object proxy;
        private final Object target;
        private final Method method;
        private final Object[] args;
        private final MethodProxy methodProxy;

        public MethodProxyInvocation(Object proxy, Object target, Method method, Object[] args, MethodProxy methodProxy) {
            this.proxy = proxy;
            this.target = target;
            this.method = method;
            this.methodProxy = methodProxy;
            this.args = ObjectUtil.defaultIfNull(ArrayUtils.clone((Object[])args), ProxyUtil.EMPTY_ARGUMENTS);
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public Object[] getArguments() {
            return this.args;
        }

        @Override
        public Object proceed() throws Throwable {
            return this.methodProxy.invoke(this.target, this.args);
        }

        @Override
        public Object getProxy() {
            return this.proxy;
        }
    }

    private static class InvokerBridge
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 7546458626135844153L;
        private final ObjectInvoker original;

        public InvokerBridge(ObjectInvoker original) {
            this.original = original;
        }

        public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
            return this.original.invoke(object, method, objects);
        }
    }

    private static class InterceptorBridge
    implements MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = -3912117109550264758L;
        private final Object target;
        private final Interceptor inner;

        public InterceptorBridge(Object target, Interceptor inner) {
            this.inner = inner;
            this.target = target;
        }

        public Object intercept(Object object, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            return this.inner.intercept(new MethodProxyInvocation(object, this.target, method, args, methodProxy));
        }
    }

    private static class HashCodeHandler
    implements MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = -2918448227794094973L;

        private HashCodeHandler() {
        }

        public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
            return System.identityHashCode(o);
        }
    }

    private static class EqualsHandler
    implements MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = -6077833602011809674L;

        private EqualsHandler() {
        }

        public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
            return o == objects[0];
        }
    }

    private static class CglibProxyFactoryCallbackFilter
    implements CallbackFilter {
        private CglibProxyFactoryCallbackFilter() {
        }

        public int accept(Method method) {
            if (ProxyUtil.isEqualsMethod(method)) {
                return 1;
            }
            if (ProxyUtil.isHashCode(method)) {
                return 2;
            }
            return 0;
        }
    }
}

