/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.uribuildertiny;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.moznion.uribuildertiny.ConcreteEntityURLEncoder;
import net.moznion.uribuildertiny.NopEntityURLEncoder;
import net.moznion.uribuildertiny.URLEncoder;

public class URIBuilderTiny {
    private String scheme;
    private String host;
    private int port;
    private List<String> paths;
    private Map<String, String> queryParameters;
    private String fragment;
    private boolean forceRemoveTrailingSlash;
    private final URLEncoder urlEncoder;
    private final URLEncoder nopURLEncoder;
    private static final Pattern CONSECUTIVE_SLASHES_RE = Pattern.compile("/+");

    public URIBuilderTiny() {
        this(URI.create(""));
    }

    public URIBuilderTiny(@NonNull String uriString) {
        this(URI.create(uriString));
        if (uriString == null) {
            throw new NullPointerException("uriString");
        }
    }

    public URIBuilderTiny(@NonNull URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        this.scheme = uri.getScheme();
        if (this.scheme == null) {
            this.scheme = "";
        }
        this.host = uri.getHost();
        if (this.host == null) {
            this.host = "";
        }
        this.port = uri.getPort();
        this.fragment = uri.getFragment();
        if (this.fragment == null) {
            this.fragment = "";
        }
        this.paths = new ArrayList<String>();
        String pathString = uri.getPath();
        if (pathString != null && !pathString.isEmpty()) {
            this.paths.addAll(Arrays.asList(pathString.split("/")));
        }
        this.queryParameters = new TreeMap<String, String>();
        String queryString = uri.getQuery();
        if (queryString != null && !queryString.isEmpty()) {
            for (String term : queryString.split("&")) {
                String[] kv = term.split("=");
                if (kv.length != 2) continue;
                this.queryParameters.put(kv[0], kv[1]);
            }
        }
        this.urlEncoder = new URLEncoder(new ConcreteEntityURLEncoder(StandardCharsets.UTF_8));
        this.nopURLEncoder = new URLEncoder(new NopEntityURLEncoder());
        this.forceRemoveTrailingSlash = false;
    }

    public URIBuilderTiny setScheme(@NonNull String scheme) {
        if (scheme == null) {
            throw new NullPointerException("scheme");
        }
        this.scheme = scheme;
        return this;
    }

    public URIBuilderTiny setHost(@NonNull String host) {
        if (host == null) {
            throw new NullPointerException("host");
        }
        return this.setHost(this.urlEncoder, host);
    }

    public URIBuilderTiny setRawHost(@NonNull String host) {
        if (host == null) {
            throw new NullPointerException("host");
        }
        return this.setHost(this.nopURLEncoder, host);
    }

    private URIBuilderTiny setHost(URLEncoder urlEncoder, @NonNull String host) {
        if (host == null) {
            throw new NullPointerException("host");
        }
        boolean isTrailingSlash = false;
        int hostLength = host.length();
        if (host.substring(hostLength - 1).equals("/")) {
            host = host.substring(0, hostLength - 1);
            isTrailingSlash = true;
        }
        this.host = urlEncoder.encode(host);
        if (isTrailingSlash) {
            this.host = this.host + "/";
        }
        return this;
    }

    public URIBuilderTiny setPort(int port) {
        this.port = port;
        return this;
    }

    public URIBuilderTiny setPaths(@NonNull List<?> paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        return this.setPaths(this.urlEncoder, paths);
    }

    public URIBuilderTiny setRawPaths(@NonNull List<?> paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        return this.setPaths(this.nopURLEncoder, paths);
    }

    private URIBuilderTiny setPaths(URLEncoder urlEncoder, @NonNull List<?> paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        this.paths.clear();
        this.paths.addAll(urlEncoder.encode(paths));
        return this;
    }

    public URIBuilderTiny setPaths(Object ... paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        return this.setPaths(this.urlEncoder, paths);
    }

    public URIBuilderTiny setRawPaths(Object ... paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        return this.setPaths(this.nopURLEncoder, paths);
    }

    private URIBuilderTiny setPaths(URLEncoder urlEncoder, Object ... paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        this.paths.clear();
        this.paths.addAll(urlEncoder.encode(Arrays.asList(paths)));
        return this;
    }

    public URIBuilderTiny setPathsByString(@NonNull String paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        return this.setPathsByString(this.urlEncoder, paths);
    }

    public URIBuilderTiny setRawPathsByString(@NonNull String paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        return this.setPathsByString(this.nopURLEncoder, paths);
    }

    private URIBuilderTiny setPathsByString(URLEncoder urlEncoder, @NonNull String paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        this.paths.clear();
        this.paths.addAll(urlEncoder.encode(Arrays.asList(paths.split("/"))));
        return this;
    }

    public URIBuilderTiny appendPaths(@NonNull List<?> paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        return this.appendPaths(this.urlEncoder, paths);
    }

    public URIBuilderTiny appendRawPaths(@NonNull List<?> paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        return this.appendPaths(this.nopURLEncoder, paths);
    }

    private URIBuilderTiny appendPaths(URLEncoder urlEncoder, @NonNull List<?> paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        this.paths.addAll(urlEncoder.encode(paths));
        return this;
    }

    public URIBuilderTiny appendPaths(Object ... paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        return this.appendPaths(this.urlEncoder, paths);
    }

    public URIBuilderTiny appendRawPaths(Object ... paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        return this.appendPaths(this.nopURLEncoder, paths);
    }

    private URIBuilderTiny appendPaths(URLEncoder urlEncoder, Object ... paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        this.paths.addAll(urlEncoder.encode(Arrays.asList(paths)));
        return this;
    }

    public URIBuilderTiny appendPathsByString(@NonNull String paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        return this.appendPathsByString(this.urlEncoder, paths);
    }

    public URIBuilderTiny appendRawPathsByString(@NonNull String paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        return this.appendPathsByString(this.nopURLEncoder, paths);
    }

    private URIBuilderTiny appendPathsByString(URLEncoder urlEncoder, @NonNull String paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        this.paths.addAll(urlEncoder.encode(Arrays.asList(paths.split("/"))));
        return this;
    }

    public <T> URIBuilderTiny setQueryParameters(@NonNull Map<String, T> queryParameters) {
        if (queryParameters == null) {
            throw new NullPointerException("queryParameters");
        }
        return this.setQueryParameters(this.urlEncoder, queryParameters);
    }

    public <T> URIBuilderTiny setRawQueryParameters(@NonNull Map<String, T> queryParameters) {
        if (queryParameters == null) {
            throw new NullPointerException("queryParameters");
        }
        return this.setQueryParameters(this.nopURLEncoder, queryParameters);
    }

    private <T> URIBuilderTiny setQueryParameters(URLEncoder urlEncoder, @NonNull Map<String, T> queryParameters) {
        if (queryParameters == null) {
            throw new NullPointerException("queryParameters");
        }
        this.queryParameters.clear();
        this.queryParameters.putAll(urlEncoder.encode(queryParameters));
        return this;
    }

    public URIBuilderTiny setQueryParameter(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.setQueryParameter(this.urlEncoder, key, value);
    }

    public URIBuilderTiny setRawQueryParameter(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.setQueryParameter(this.nopURLEncoder, key, value);
    }

    private URIBuilderTiny setQueryParameter(URLEncoder urlEncoder, @NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.queryParameters.clear();
        this.queryParameters.put(urlEncoder.encode(key), urlEncoder.encode(value));
        return this;
    }

    public URIBuilderTiny addQueryParameters(@NonNull Map<String, ?> queryParameters) {
        if (queryParameters == null) {
            throw new NullPointerException("queryParameters");
        }
        return this.addQueryParameters(this.urlEncoder, queryParameters);
    }

    public URIBuilderTiny addRawQueryParameters(@NonNull Map<String, ?> queryParameters) {
        if (queryParameters == null) {
            throw new NullPointerException("queryParameters");
        }
        return this.addQueryParameters(this.nopURLEncoder, queryParameters);
    }

    private URIBuilderTiny addQueryParameters(URLEncoder urlEncoder, @NonNull Map<String, ?> queryParameters) {
        if (queryParameters == null) {
            throw new NullPointerException("queryParameters");
        }
        this.queryParameters.putAll(urlEncoder.encode(queryParameters));
        return this;
    }

    public URIBuilderTiny addQueryParameter(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.addQueryParameter(this.urlEncoder, key, value);
    }

    public URIBuilderTiny addRawQueryParameter(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.addQueryParameter(this.nopURLEncoder, key, value);
    }

    private URIBuilderTiny addQueryParameter(URLEncoder urlEncoder, @NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.queryParameters.put(urlEncoder.encode(key), urlEncoder.encode(value));
        return this;
    }

    public URIBuilderTiny setFragment(@NonNull String fragment) {
        if (fragment == null) {
            throw new NullPointerException("fragment");
        }
        return this.setFragment(this.urlEncoder, fragment);
    }

    public URIBuilderTiny setRawFragment(@NonNull String fragment) {
        if (fragment == null) {
            throw new NullPointerException("fragment");
        }
        return this.setFragment(this.nopURLEncoder, fragment);
    }

    private URIBuilderTiny setFragment(URLEncoder urlEncoder, @NonNull String fragment) {
        if (fragment == null) {
            throw new NullPointerException("fragment");
        }
        this.fragment = urlEncoder.encode(fragment);
        return this;
    }

    public URIBuilderTiny forceRemoveTrailingSlash(boolean shouldRemove) {
        this.forceRemoveTrailingSlash = shouldRemove;
        return this;
    }

    public URI build() {
        StringBuilder baseURIStringBuilder = new StringBuilder();
        boolean shouldAppendTrailingSlash = false;
        if (!this.host.isEmpty()) {
            if (this.host.charAt(this.host.length() - 1) == '/') {
                shouldAppendTrailingSlash = !this.forceRemoveTrailingSlash;
                this.host = this.host.substring(0, this.host.length() - 1);
            }
            baseURIStringBuilder.append(this.host);
        }
        if (this.port >= 0) {
            baseURIStringBuilder.append(":").append(this.port);
        }
        if (!this.paths.isEmpty()) {
            for (String path : this.paths) {
                if (path.isEmpty()) continue;
                baseURIStringBuilder.append("/").append(path);
            }
        }
        if (shouldAppendTrailingSlash) {
            baseURIStringBuilder.append("/");
        }
        String uriString = baseURIStringBuilder.toString();
        uriString = CONSECUTIVE_SLASHES_RE.matcher(uriString).replaceAll("/");
        StringBuilder queryAndFragmentStringBuilder = new StringBuilder();
        if (!this.queryParameters.isEmpty()) {
            queryAndFragmentStringBuilder.append("?");
            int i = 1;
            int size = this.queryParameters.size();
            for (Map.Entry<String, String> queryParameter : this.queryParameters.entrySet()) {
                queryAndFragmentStringBuilder.append(queryParameter.getKey()).append("=").append(queryParameter.getValue());
                if (i != size) {
                    queryAndFragmentStringBuilder.append("&");
                }
                ++i;
            }
        }
        if (!this.fragment.isEmpty()) {
            queryAndFragmentStringBuilder.append("#").append(this.fragment);
        }
        uriString = uriString + queryAndFragmentStringBuilder.toString();
        if (!this.scheme.isEmpty()) {
            String glue = "://";
            if (uriString.charAt(0) == '/') {
                glue = ":/";
            }
            uriString = this.scheme + glue + uriString;
        }
        return URI.create(uriString);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean isForceRemoveTrailingSlash() {
        return this.forceRemoveTrailingSlash;
    }
}

