/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.uribuildertiny;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import lombok.NonNull;
import net.moznion.uribuildertiny.EntityURLEncoder;

class ConcreteEntityURLEncoder
implements EntityURLEncoder {
    private final String encodingCharsetName;

    ConcreteEntityURLEncoder(Charset encodingCharset) {
        this.encodingCharsetName = encodingCharset.name();
    }

    @Override
    public String encode(@NonNull Object input) {
        if (input == null) {
            throw new NullPointerException("input");
        }
        try {
            return URLEncoder.encode(input.toString(), this.encodingCharsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

