/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.physics;

import com.artemis.Aspect;
import com.artemis.ComponentMapper;
import com.artemis.Entity;
import com.artemis.annotations.Wire;
import com.artemis.systems.EntityProcessingSystem;
import net.mostlyoriginal.api.component.physics.Gravity;
import net.mostlyoriginal.api.component.physics.Physics;

@Wire
public class GravitySystem
extends EntityProcessingSystem {
    public static final int GRAVITY_FACTOR = 50;
    ComponentMapper<Physics> pm;
    ComponentMapper<Gravity> gm;

    public GravitySystem() {
        super(Aspect.getAspectForAll((Class[])new Class[]{Gravity.class, Physics.class}));
    }

    protected void process(Entity e) {
        Physics physics = (Physics)this.pm.get(e);
        Gravity gravity = (Gravity)this.gm.get(e);
        physics.vy += gravity.y * 50.0f * this.world.delta;
        physics.vx += gravity.x * 50.0f * this.world.delta;
    }
}

