/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.graphics;

import com.artemis.Aspect;
import com.artemis.ComponentMapper;
import com.artemis.Entity;
import com.artemis.EntitySystem;
import com.artemis.annotations.Wire;
import com.artemis.utils.Bag;
import com.artemis.utils.ImmutableBag;
import net.mostlyoriginal.api.component.graphics.Renderable;
import net.mostlyoriginal.api.system.delegate.EntityProcessAgent;
import net.mostlyoriginal.api.system.delegate.EntityProcessPrincipal;
import net.mostlyoriginal.api.utils.BagUtils;

@Wire
public class RenderBatchingSystem
extends EntitySystem
implements EntityProcessPrincipal {
    protected ComponentMapper<Renderable> mRenderable;
    protected final Bag<Job> sortedJobs = new Bag();
    public boolean sortedDirty = false;

    public RenderBatchingSystem() {
        super(Aspect.getEmpty());
    }

    public void registerAgent(Entity e, EntityProcessAgent agent) {
        if (!this.mRenderable.has(e)) {
            throw new RuntimeException("RenderBatchingSystem requires agents entities to have component Renderable.");
        }
        this.sortedJobs.add((Object)new Job(e, agent));
        this.sortedDirty = true;
    }

    public void unregisterAgent(Entity e, EntityProcessAgent agent) {
        Object[] data = this.sortedJobs.getData();
        int s = this.sortedJobs.size();
        for (int i = 0; i < s; ++i) {
            Job e2 = (Job)data[i];
            if (e2.entity != e || e2.agent != agent) continue;
            this.sortedJobs.remove(i);
            this.sortedDirty = true;
            break;
        }
    }

    protected void processEntities(ImmutableBag<Entity> entities) {
        if (this.sortedDirty) {
            this.sortedDirty = false;
            BagUtils.sort(this.sortedJobs);
        }
        EntityProcessAgent activeAgent = null;
        Object[] data = this.sortedJobs.getData();
        int s = this.sortedJobs.size();
        for (int i = 0; i < s; ++i) {
            Job job = (Job)data[i];
            EntityProcessAgent agent = job.agent;
            if (agent != activeAgent) {
                if (activeAgent != null) {
                    activeAgent.end();
                }
                activeAgent = agent;
                activeAgent.begin();
            }
            agent.process(job.entity);
        }
        if (activeAgent != null) {
            activeAgent.end();
        }
    }

    protected boolean checkProcessing() {
        return true;
    }

    public class Job
    implements Comparable<Job> {
        public final Entity entity;
        public final EntityProcessAgent agent;

        public Job(Entity entity, EntityProcessAgent agent) {
            this.entity = entity;
            this.agent = agent;
        }

        @Override
        public int compareTo(Job o) {
            return ((Renderable)RenderBatchingSystem.this.mRenderable.get((Entity)this.entity)).layer - ((Renderable)RenderBatchingSystem.this.mRenderable.get((Entity)o.entity)).layer;
        }
    }
}

