/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.graphics;

import com.artemis.Aspect;
import com.artemis.ComponentMapper;
import com.artemis.Entity;
import com.artemis.annotations.Wire;
import com.artemis.systems.EntityProcessingSystem;
import net.mostlyoriginal.api.component.graphics.Color;
import net.mostlyoriginal.api.component.graphics.ColorAnimation;

@Wire
public class ColorAnimationSystem
extends EntityProcessingSystem {
    protected ComponentMapper<Color> mColor;
    protected ComponentMapper<ColorAnimation> cm;

    public ColorAnimationSystem() {
        super(Aspect.getAspectForAll((Class[])new Class[]{Color.class, ColorAnimation.class}));
    }

    protected void process(Entity entity) {
        ColorAnimation colorAnimation = (ColorAnimation)this.cm.get(entity);
        Color color = (Color)this.mColor.get(entity);
        colorAnimation.age.r += colorAnimation.speed.r * this.world.delta;
        colorAnimation.age.g += colorAnimation.speed.g * this.world.delta;
        colorAnimation.age.b += colorAnimation.speed.b * this.world.delta;
        colorAnimation.age.a += colorAnimation.speed.a * this.world.delta;
        color.r = colorAnimation.tween.apply(colorAnimation.startColor.r, colorAnimation.endColor.r, 1.0f - Math.abs(colorAnimation.age.r % 2.0f - 1.0f));
        color.g = colorAnimation.tween.apply(colorAnimation.startColor.g, colorAnimation.endColor.g, 1.0f - Math.abs(colorAnimation.age.g % 2.0f - 1.0f));
        color.b = colorAnimation.tween.apply(colorAnimation.startColor.b, colorAnimation.endColor.b, 1.0f - Math.abs(colorAnimation.age.b % 2.0f - 1.0f));
        color.a = colorAnimation.tween.apply(colorAnimation.startColor.a, colorAnimation.endColor.a, 1.0f - Math.abs(colorAnimation.age.a % 2.0f - 1.0f));
        if (colorAnimation.duration != -1.0f) {
            colorAnimation.duration -= this.world.delta;
            if (colorAnimation.duration <= 0.0f) {
                color.set(1.0f, 1.0f, 1.0f, 1.0f);
                entity.edit().remove(ColorAnimation.class);
            }
        }
    }
}

