/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.proto.testing.matchers;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.morimekta.collect.UnmodifiableSet;
import net.morimekta.collect.util.SetOperations;
import net.morimekta.proto.ProtoMessage;
import net.morimekta.proto.utils.ByteStringUtil;
import net.morimekta.proto.utils.FieldUtil;
import net.morimekta.proto.utils.ValueUtil;
import net.morimekta.strings.Stringable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class EqualMessageIgnoring<M extends Message>
extends BaseMatcher<M> {
    protected final M expected;
    private final Set<String> ignoringFields;
    private final boolean ignoreExtensions;

    public EqualMessageIgnoring(M expected, boolean ignoreExtensions, Set<String> ignoringFields) {
        ignoringFields.forEach(path -> FieldUtil.fieldPathToFields((Descriptors.Descriptor)expected.getDescriptorForType(), (String)path));
        this.expected = (Message)Objects.requireNonNull(expected, "expected == null");
        this.ignoringFields = UnmodifiableSet.asSet(ignoringFields);
        this.ignoreExtensions = ignoreExtensions;
    }

    public boolean matches(Object o) {
        if (!(o instanceof Message)) {
            return false;
        }
        if (!this.expected.getClass().equals(o.getClass())) {
            return false;
        }
        if (this.ignoringFields.isEmpty() && !this.ignoreExtensions) {
            return this.expected.equals(o);
        }
        return EqualMessageIgnoring.equalsIgnoring(this.expected, o, this.ignoreExtensions, this.ignoringFields);
    }

    public void describeTo(Description description) {
        if (this.ignoreExtensions || !this.ignoringFields.isEmpty()) {
            description.appendText(this.expected.getDescriptorForType().getFullName());
            EqualMessageIgnoring.appendValueIgnoring("", this.expected, description, this.ignoreExtensions, this.ignoringFields);
        } else {
            description.appendText(ValueUtil.toDebugString(this.expected));
        }
    }

    public void describeMismatch(Object item, Description description) {
        if (item instanceof Message) {
            Message actual = (Message)item;
            description.appendText("was ");
            if (this.ignoreExtensions || !this.ignoringFields.isEmpty()) {
                description.appendText(actual.getDescriptorForType().getFullName());
                EqualMessageIgnoring.appendValueIgnoring("", actual, description, this.ignoreExtensions, this.ignoringFields);
            } else {
                description.appendText(ValueUtil.toDebugString((Message)actual));
            }
        } else {
            super.describeMismatch(item, description);
        }
    }

    private static void appendValueIgnoring(String prefix, Object value, Description description, boolean ignoreExtensions, Set<String> ignoringFields) {
        if (value instanceof Message) {
            Message msg = (Message)value;
            List allFields = msg.getAllFields().entrySet().stream().filter(field -> {
                if (((Descriptors.FieldDescriptor)field.getKey()).isExtension() && ignoreExtensions) {
                    return false;
                }
                return !ignoringFields.contains(((Descriptors.FieldDescriptor)field.getKey()).getName());
            }).collect(Collectors.toList());
            if (allFields.isEmpty()) {
                description.appendText("{}");
                return;
            }
            description.appendText("{\n");
            for (Map.Entry fieldEntry : allFields) {
                Object val = ValueUtil.toJavaValue((Descriptors.FieldDescriptor)((Descriptors.FieldDescriptor)fieldEntry.getKey()), fieldEntry.getValue());
                description.appendText(prefix).appendText("  ");
                if (((Descriptors.FieldDescriptor)fieldEntry.getKey()).isExtension()) {
                    description.appendText("(").appendText(((Descriptors.FieldDescriptor)fieldEntry.getKey()).getFullName()).appendText(")");
                } else {
                    description.appendText(((Descriptors.FieldDescriptor)fieldEntry.getKey()).getName());
                }
                description.appendText(" = ");
                EqualMessageIgnoring.appendValueIgnoring(prefix + "  ", val, description, ignoreExtensions, FieldUtil.filterFields(ignoringFields, (Descriptors.FieldDescriptor)((Descriptors.FieldDescriptor)fieldEntry.getKey())));
                description.appendText("\n");
            }
            description.appendText(prefix).appendText("}");
        } else if (value instanceof Map) {
            description.appendText("{");
            boolean first = true;
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if (first) {
                    first = false;
                } else {
                    description.appendText(",");
                }
                description.appendText("\n").appendText(prefix).appendText("  ").appendText(Stringable.asString(entry.getKey())).appendText(": ");
                EqualMessageIgnoring.appendValueIgnoring(prefix + "  ", entry.getValue(), description, ignoreExtensions, ignoringFields);
            }
            description.appendText("\n").appendText(prefix).appendText("}");
        } else if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                description.appendText("[]");
            } else {
                Object first = list.get(0);
                if (list.size() > 5 || first instanceof Message || first instanceof ByteString || first instanceof String) {
                    description.appendText("[\n");
                    for (Object item : list) {
                        if (first != null) {
                            first = null;
                        } else {
                            description.appendText(",\n");
                        }
                        description.appendText(prefix + "  ");
                        EqualMessageIgnoring.appendValueIgnoring(prefix + "  ", item, description, ignoreExtensions, ignoringFields);
                    }
                    description.appendText("\n").appendText(prefix).appendText("]");
                } else {
                    description.appendText("[");
                    for (Object item : list) {
                        if (first != null) {
                            first = null;
                        } else {
                            description.appendText(", ");
                        }
                        description.appendText(Stringable.asString(item));
                    }
                    description.appendText("]");
                }
            }
        } else if (value instanceof ByteString) {
            description.appendText("b64(").appendText(ByteStringUtil.toBase64((ByteString)((ByteString)value))).appendText(")");
        } else {
            description.appendText(Stringable.asString((Object)value));
        }
    }

    private static boolean equalsIgnoring(Object expected, Object actual, boolean ignoreExtensions, Set<String> ignoringFields) {
        if (Objects.equals(expected, actual)) {
            return true;
        }
        if (expected instanceof Message && actual instanceof Message) {
            if (ignoringFields.isEmpty() && !ignoreExtensions) {
                return false;
            }
            ProtoMessage mExp = new ProtoMessage((MessageOrBuilder)expected);
            ProtoMessage mAct = new ProtoMessage((MessageOrBuilder)actual);
            List allFields = SetOperations.union((Set[])new Set[]{mExp.getMessage().getAllFields().keySet(), mAct.getMessage().getAllFields().keySet()}).stream().filter(field -> {
                if (field.isExtension() && ignoreExtensions) {
                    return false;
                }
                return !ignoringFields.contains(field.getName());
            }).collect(Collectors.toList());
            for (Descriptors.FieldDescriptor field2 : allFields) {
                if (field2.isExtension() && ignoreExtensions || EqualMessageIgnoring.equalsIgnoring(mExp.optional(field2).orElse(null), mAct.optional(field2).orElse(null), ignoreExtensions, FieldUtil.filterFields(ignoringFields, (Descriptors.FieldDescriptor)field2))) continue;
                return false;
            }
            return true;
        }
        if (expected instanceof Map && actual instanceof Map) {
            Map expMap = (Map)expected;
            Map actMap = (Map)actual;
            if (!expMap.keySet().equals(actMap.keySet())) {
                return false;
            }
            for (Map.Entry expEntry : expMap.entrySet()) {
                if (EqualMessageIgnoring.equalsIgnoring(expEntry.getValue(), actMap.get(expEntry.getKey()), ignoreExtensions, ignoringFields)) continue;
                return false;
            }
            return true;
        }
        if (expected instanceof List && actual instanceof List) {
            List expList = (List)expected;
            List actList = (List)actual;
            if (expList.size() != actList.size()) {
                return false;
            }
            for (int i = 0; i < expList.size(); ++i) {
                if (EqualMessageIgnoring.equalsIgnoring(expList.get(i), actList.get(i), ignoreExtensions, ignoringFields)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

