/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;
import java.util.UUID;

public class ParcelUuid
implements Parcelable {
    public static final Parcelable.Creator<ParcelUuid> CREATOR = new Parcelable.Creator<ParcelUuid>(){

        @Override
        public ParcelUuid createFromParcel(Parcel source) {
            long most = source.readLong();
            long least = source.readLong();
            return new ParcelUuid(new UUID(most, least));
        }

        public ParcelUuid[] newArray(int size) {
            return new ParcelUuid[size];
        }
    };
    private final UUID uuid;

    public ParcelUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public static ParcelUuid fromString(String uuid) {
        return new ParcelUuid(UUID.fromString(uuid));
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ParcelUuid other = (ParcelUuid)o;
        return Objects.equals(this.uuid, other.uuid);
    }

    public int hashCode() {
        return Objects.hashCode(this.uuid);
    }

    public String toString() {
        return Objects.toString(this.uuid);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.uuid.getMostSignificantBits());
        dest.writeLong(this.uuid.getLeastSignificantBits());
    }
}

