/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core.networking.encoding;

import com.testflightapp.lib.core.Logger;
import com.testflightapp.lib.core.networking.encoding.DecoderFormatException;
import com.testflightapp.lib.core.networking.encoding.IParameterDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONParameterDecoder
implements IParameterDecoder {
    @Override
    public Map<String, Object> decode(HttpEntity httpEntity) throws DecoderFormatException {
        String string;
        if (httpEntity == null) {
            Logger.e("null passed to JSONParameterDecoder.decode");
            throw new NullPointerException("null parameter passed to JSONParameterDecoder.decode");
        }
        try {
            string = EntityUtils.toString((HttpEntity)httpEntity);
        }
        catch (Throwable throwable) {
            Logger.w("Unexpected error decoding data:\r\n" + throwable.toString(), throwable);
            throw new DecoderFormatException("Unexpected error decoding data.", throwable);
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            return this.extractMembers(jSONObject);
        }
        catch (JSONException jSONException) {
            Logger.w("Error decoding json:\r\n" + string, jSONException);
            throw new DecoderFormatException("JSONException thrown from JSONParameterDecoder.decode.  For details see the exception cause.", jSONException);
        }
    }

    private Map<String, Object> extractMembers(JSONObject jSONObject) throws JSONException, DecoderFormatException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = jSONObject.get(string);
            hashMap.put(string, this.extractMember(object));
        }
        return hashMap;
    }

    private Object extractMember(Object object) throws JSONException, DecoderFormatException {
        if (object == JSONObject.NULL) {
            return null;
        }
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        if (object instanceof Double) {
            return Float.valueOf((float)((Double)object).doubleValue());
        }
        if (object instanceof Integer || object instanceof Float || object instanceof Boolean || object instanceof String) {
            return object;
        }
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            Object[] objectArray = new Object[jSONArray.length()];
            for (int i = 0; i < jSONArray.length(); ++i) {
                objectArray[i] = this.extractMember(jSONArray.get(i));
            }
            return objectArray;
        }
        if (object instanceof JSONObject) {
            return this.extractMembers((JSONObject)object);
        }
        String string = object.getClass().toString() + " cannot be decoded by JSONParameterDecoder.";
        Logger.w(string);
        throw new DecoderFormatException(string);
    }
}

