/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.acra.sender;

import android.net.Uri;
import android.util.Log;
import com.testflightapp.acra.ACRA;
import com.testflightapp.acra.ACRAConstants;
import com.testflightapp.acra.ReportField;
import com.testflightapp.acra.collector.CrashReportData;
import com.testflightapp.acra.sender.HttpSender;
import com.testflightapp.acra.sender.ReportSender;
import com.testflightapp.acra.sender.ReportSenderException;
import com.testflightapp.acra.util.HttpRequest;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class GoogleFormSender
implements ReportSender {
    private final Uri mFormUri;

    public GoogleFormSender() {
        this.mFormUri = null;
    }

    public GoogleFormSender(String formKey) {
        this.mFormUri = Uri.parse((String)String.format(ACRA.getConfig().googleFormUrlFormat(), formKey));
    }

    @Override
    public void send(CrashReportData report) throws ReportSenderException {
        Uri formUri = this.mFormUri == null ? Uri.parse((String)String.format(ACRA.getConfig().googleFormUrlFormat(), ACRA.getConfig().formKey())) : this.mFormUri;
        Map<String, String> formParams = this.remap(report);
        formParams.put("pageNumber", "0");
        formParams.put("backupCache", "");
        formParams.put("submit", "Envoyer");
        try {
            URL reportUrl = new URL(formUri.toString());
            Log.d((String)ACRA.LOG_TAG, (String)("Sending report " + (String)report.get((Object)ReportField.REPORT_ID)));
            Log.d((String)ACRA.LOG_TAG, (String)("Connect to " + reportUrl));
            HttpRequest request = new HttpRequest();
            request.setConnectionTimeOut(ACRA.getConfig().connectionTimeout());
            request.setSocketTimeOut(ACRA.getConfig().socketTimeout());
            request.setMaxNrRetries(ACRA.getConfig().maxNumberOfRequestRetries());
            request.send(reportUrl, HttpSender.Method.POST, HttpRequest.getParamsAsFormString(formParams), HttpSender.Type.FORM);
        }
        catch (IOException e) {
            throw new ReportSenderException("Error while sending report to Google Form.", e);
        }
    }

    private Map<String, String> remap(Map<ReportField, String> report) {
        ReportField[] fields = ACRA.getConfig().customReportContent();
        if (fields.length == 0) {
            fields = ACRAConstants.DEFAULT_REPORT_FIELDS;
        }
        int inputId = 0;
        HashMap<String, String> result = new HashMap<String, String>();
        for (ReportField originalKey : fields) {
            switch (originalKey) {
                case APP_VERSION_NAME: {
                    result.put("entry." + inputId + ".single", "'" + report.get((Object)originalKey));
                    break;
                }
                case ANDROID_VERSION: {
                    result.put("entry." + inputId + ".single", "'" + report.get((Object)originalKey));
                    break;
                }
                default: {
                    result.put("entry." + inputId + ".single", report.get((Object)originalKey));
                }
            }
            ++inputId;
        }
        return result;
    }
}

