/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.acra.collector;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.util.Log;
import com.testflightapp.acra.ACRA;
import com.testflightapp.acra.collector.Compatibility;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class SettingsCollector {
    SettingsCollector() {
    }

    public static String collectSystemSettings(Context ctx) {
        Field[] keys;
        StringBuilder result = new StringBuilder();
        for (Field key : keys = Settings.System.class.getFields()) {
            if (key.isAnnotationPresent(Deprecated.class) || key.getType() != String.class) continue;
            try {
                String value = Settings.System.getString((ContentResolver)ctx.getContentResolver(), (String)((String)key.get(null)));
                if (value == null) continue;
                result.append(key.getName()).append("=").append((Object)value).append("\n");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
            }
        }
        return result.toString();
    }

    public static String collectSecureSettings(Context ctx) {
        Field[] keys;
        StringBuilder result = new StringBuilder();
        for (Field key : keys = Settings.Secure.class.getFields()) {
            if (key.isAnnotationPresent(Deprecated.class) || key.getType() != String.class || !SettingsCollector.isAuthorized(key)) continue;
            try {
                String value = Settings.Secure.getString((ContentResolver)ctx.getContentResolver(), (String)((String)key.get(null)));
                if (value == null) continue;
                result.append(key.getName()).append("=").append((Object)value).append("\n");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
            }
        }
        return result.toString();
    }

    public static String collectGlobalSettings(Context ctx) {
        if (Compatibility.getAPILevel() < 17) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        try {
            Class<?> globalClass = Class.forName("android.provider.Settings$Global");
            Field[] keys = globalClass.getFields();
            Method getString = globalClass.getMethod("getString", ContentResolver.class, String.class);
            for (Field key : keys) {
                Object value;
                if (key.isAnnotationPresent(Deprecated.class) || key.getType() != String.class || !SettingsCollector.isAuthorized(key) || (value = getString.invoke(null, ctx.getContentResolver(), (String)key.get(null))) == null) continue;
                result.append(key.getName()).append("=").append(value).append("\n");
            }
        }
        catch (IllegalArgumentException e) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
        }
        catch (SecurityException e) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
        }
        return result.toString();
    }

    private static boolean isAuthorized(Field key) {
        if (key == null || key.getName().startsWith("WIFI_AP")) {
            return false;
        }
        for (String regex : ACRA.getConfig().excludeMatchingSettingsKeys()) {
            if (!key.getName().matches(regex)) continue;
            return false;
        }
        return true;
    }
}

