/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.acra.collector;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class ReflectionCollector {
    ReflectionCollector() {
    }

    public static String collectConstants(Class<?> someClass, String prefix) {
        Field[] fields;
        StringBuilder result = new StringBuilder();
        for (Field field : fields = someClass.getFields()) {
            if (prefix != null && prefix.length() > 0) {
                result.append(prefix).append('.');
            }
            result.append(field.getName()).append("=");
            try {
                result.append(field.get(null).toString());
            }
            catch (IllegalArgumentException e) {
                result.append("N/A");
            }
            catch (IllegalAccessException e) {
                result.append("N/A");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public static String collectStaticGettersResults(Class<?> someClass) {
        Method[] methods;
        StringBuilder result = new StringBuilder();
        for (Method method : methods = someClass.getMethods()) {
            if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is") || method.getName().equals("getClass")) continue;
            try {
                result.append(method.getName());
                result.append('=');
                result.append(method.invoke(null, (Object[])null));
                result.append("\n");
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        return result.toString();
    }

    public static String collectConstants(Class<?> someClass) {
        return ReflectionCollector.collectConstants(someClass, "");
    }
}

