/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.acra.sender;

import android.content.Context;
import android.content.Intent;
import com.testflightapp.acra.ACRA;
import com.testflightapp.acra.ACRAConstants;
import com.testflightapp.acra.ReportField;
import com.testflightapp.acra.collector.CrashReportData;
import com.testflightapp.acra.sender.ReportSender;
import com.testflightapp.acra.sender.ReportSenderException;

public class EmailIntentSender
implements ReportSender {
    private final Context mContext;

    public EmailIntentSender(Context ctx) {
        this.mContext = ctx;
    }

    @Override
    public void send(CrashReportData errorContent) throws ReportSenderException {
        String subject = this.mContext.getPackageName() + " Crash Report";
        String body = this.buildBody(errorContent);
        Intent emailIntent = new Intent("android.intent.action.SEND");
        emailIntent.addFlags(0x10000000);
        emailIntent.setType("text/plain");
        emailIntent.putExtra("android.intent.extra.SUBJECT", subject);
        emailIntent.putExtra("android.intent.extra.TEXT", body);
        emailIntent.putExtra("android.intent.extra.EMAIL", new String[]{ACRA.getConfig().mailTo()});
        this.mContext.startActivity(emailIntent);
    }

    private String buildBody(CrashReportData errorContent) {
        ReportField[] fields = ACRA.getConfig().customReportContent();
        if (fields.length == 0) {
            fields = ACRAConstants.DEFAULT_MAIL_REPORT_FIELDS;
        }
        StringBuilder builder = new StringBuilder();
        for (ReportField field : fields) {
            builder.append(field.toString()).append("=");
            builder.append((String)errorContent.get((Object)field));
            builder.append('\n');
        }
        return builder.toString();
    }
}

