/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.acra.collector;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.testflightapp.acra.ACRA;
import java.util.Map;
import java.util.TreeMap;

final class SharedPreferencesCollector {
    SharedPreferencesCollector() {
    }

    public static String collect(Context context) {
        StringBuilder result = new StringBuilder();
        TreeMap<String, SharedPreferences> shrdPrefs = new TreeMap<String, SharedPreferences>();
        shrdPrefs.put("default", PreferenceManager.getDefaultSharedPreferences((Context)context));
        String[] shrdPrefsIds = ACRA.getConfig().additionalSharedPreferences();
        if (shrdPrefsIds != null) {
            for (String shrdPrefId : shrdPrefsIds) {
                shrdPrefs.put(shrdPrefId, context.getSharedPreferences(shrdPrefId, 0));
            }
        }
        for (String prefsId : shrdPrefs.keySet()) {
            SharedPreferences prefs = (SharedPreferences)shrdPrefs.get(prefsId);
            if (prefs != null) {
                Map kv = prefs.getAll();
                if (kv != null && kv.size() > 0) {
                    for (String key : kv.keySet()) {
                        if (SharedPreferencesCollector.filteredKey(key)) continue;
                        if (kv.get(key) != null) {
                            result.append(prefsId).append('.').append(key).append('=').append(kv.get(key).toString()).append("\n");
                            continue;
                        }
                        result.append(prefsId).append('.').append(key).append('=').append("null\n");
                    }
                } else {
                    result.append(prefsId).append('=').append("empty\n");
                }
            } else {
                result.append("null\n");
            }
            result.append('\n');
        }
        return result.toString();
    }

    private static boolean filteredKey(String key) {
        for (String regex : ACRA.getConfig().excludeMatchingSharedPreferencesKeys()) {
            if (!key.matches(regex)) continue;
            return true;
        }
        return false;
    }
}

