/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core.newapi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import com.testflightapp.lib.core.Logger;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ConnectionStateWatcher {
    static final String TAG = ConnectionStateWatcher.class.getSimpleName();
    static final List<Reference<IConnectivityListener>> LISTENERS = new ArrayList<Reference<IConnectivityListener>>();
    private static ConnectivityManager sConnectivityManager;
    private static BroadcastReceiver sNetworkStateReceiver;

    private ConnectionStateWatcher() {
    }

    public static void initRquestManager(Context context) {
        Context context2 = context.getApplicationContext();
        if (sConnectivityManager == null) {
            sConnectivityManager = (ConnectivityManager)context2.getSystemService("connectivity");
        }
        if (sNetworkStateReceiver == null) {
            sNetworkStateReceiver = new ConnectivityBroadcastReceiver();
            IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            context2.registerReceiver(sNetworkStateReceiver, intentFilter);
        }
    }

    static void notifyConnectioChanged(boolean bl) {
        Iterator<Reference<IConnectivityListener>> iterator = LISTENERS.iterator();
        while (iterator.hasNext()) {
            Reference<IConnectivityListener> reference = iterator.next();
            IConnectivityListener iConnectivityListener = reference.get();
            if (iConnectivityListener != null) {
                if (bl) {
                    iConnectivityListener.onConnected();
                    continue;
                }
                iConnectivityListener.onDisconnected();
                continue;
            }
            iterator.remove();
        }
    }

    public static boolean isConnected() {
        boolean bl = false;
        if (sConnectivityManager != null) {
            NetworkInfo networkInfo = sConnectivityManager.getActiveNetworkInfo();
            bl = networkInfo == null ? false : networkInfo.isConnected();
        }
        return bl;
    }

    public static boolean isAvailable() {
        boolean bl = false;
        if (sConnectivityManager != null) {
            NetworkInfo networkInfo = sConnectivityManager.getActiveNetworkInfo();
            bl = networkInfo == null ? false : networkInfo.isAvailable();
        }
        return bl;
    }

    public static void addConnectionListener(IConnectivityListener iConnectivityListener) {
        if (iConnectivityListener != null) {
            LISTENERS.add(new WeakReference<IConnectivityListener>(iConnectivityListener));
        }
    }

    public static void removeConnectionListener(IConnectivityListener iConnectivityListener) {
        if (iConnectivityListener != null) {
            Iterator<Reference<IConnectivityListener>> iterator = LISTENERS.iterator();
            while (iterator.hasNext()) {
                if (iConnectivityListener != iterator.next().get()) continue;
                iterator.remove();
            }
        }
    }

    private static class ConnectivityBroadcastReceiver
    extends BroadcastReceiver
    implements Runnable {
        private final Handler mUiHandler = new Handler(Looper.getMainLooper());
        private boolean mConnectedState;

        private ConnectivityBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            this.mUiHandler.post((Runnable)this);
        }

        @Override
        public void run() {
            boolean bl = ConnectionStateWatcher.isConnected();
            if (this.mConnectedState != bl) {
                ConnectionStateWatcher.notifyConnectioChanged(bl);
                this.mConnectedState = bl;
                if (bl) {
                    Logger.d(TAG, "Network connected. Resuming TF tasks...");
                } else {
                    Logger.d(TAG, "Network disconnected.");
                }
            }
        }
    }

    public static interface IConnectivityListener {
        public void onConnected();

        public void onDisconnected();
    }
}

