/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.acra.util;

import java.util.Collection;
import java.util.LinkedList;

public class BoundedLinkedList<E>
extends LinkedList<E> {
    private final int maxSize;

    public BoundedLinkedList(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean add(E object) {
        if (this.size() == this.maxSize) {
            this.removeFirst();
        }
        return super.add(object);
    }

    @Override
    public void add(int location, E object) {
        if (this.size() == this.maxSize) {
            this.removeFirst();
        }
        super.add(location, object);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        int totalNeededSize = this.size() + collection.size();
        int overhead = totalNeededSize - this.maxSize;
        if (overhead > 0) {
            this.removeRange(0, overhead);
        }
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int location, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFirst(E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLast(E object) {
        this.add(object);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Object object : this) {
            result.append(object.toString());
        }
        return result.toString();
    }
}

