/*
 * Decompiled with CFR 0.152.
 */
package com.bzutils;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AppRate {
    private static final String ALL_PREFS = ".a2r_ALL";
    private static final String INSTALL_DATE = ".a2r_INSTALL_DATE";
    private static final String HAS_RATED = ".a2r_HAS_RATED";
    private static final String APP_USES = ".a2r_APP_USES";
    private static final Method sApplyMethod = AppRate.findApplyMethod();

    public static void displayAsk2Rate(Context ctx, int days, int uses, boolean reminder, String message, String rateNow, String rateLater) {
        long currentTime;
        String packageName = AppRate.getPackageName(ctx);
        if (packageName == null) {
            return;
        }
        SharedPreferences sp = ctx.getSharedPreferences(packageName + ALL_PREFS, 0);
        SharedPreferences.Editor editor = ctx.getSharedPreferences(packageName + ALL_PREFS, 0).edit();
        long installDate = sp.getLong(packageName + INSTALL_DATE, 0L);
        if (installDate == 0L) {
            editor.putLong(packageName + INSTALL_DATE, System.currentTimeMillis());
            AppRate.apply(editor);
        }
        boolean hasRated = sp.getBoolean(packageName + HAS_RATED, false);
        int appUses = sp.getInt(packageName + APP_USES, 0);
        if (appUses < uses) {
            return;
        }
        if (!hasRated && ((currentTime = System.currentTimeMillis()) - installDate) / 86400000L >= (long)days) {
            AppRate.createAsk2RateDialog(ctx, message, rateNow, rateLater);
            if (!reminder) {
                editor.putBoolean(packageName + HAS_RATED, true);
                AppRate.apply(editor);
            }
        }
    }

    public static void displayAsk2RateWithCustomTitle(Context ctx, int days, int uses, boolean reminder, String message, String rateNow, String rateLater, String title) {
        String packageName = AppRate.getPackageName(ctx);
        if (packageName == null) {
            return;
        }
        SharedPreferences sp = ctx.getSharedPreferences(packageName + ALL_PREFS, 0);
        SharedPreferences.Editor editor = ctx.getSharedPreferences(packageName + ALL_PREFS, 0).edit();
        long installDate = sp.getLong(packageName + INSTALL_DATE, 0L);
        if (installDate == 0L) {
            editor.putLong(packageName + INSTALL_DATE, System.currentTimeMillis());
            AppRate.apply(editor);
        }
        boolean hasRated = sp.getBoolean(packageName + HAS_RATED, false);
        int appUses = sp.getInt(packageName + APP_USES, 0);
        if (appUses < uses) {
            return;
        }
        if (!hasRated) {
            long currentTime = System.currentTimeMillis();
            if ((currentTime - installDate) / 86400000L >= (long)days) {
                AppRate.createAsk2RateDialogWithCustomTitle(ctx, message, rateNow, rateLater, title, 7);
                if (!reminder) {
                    editor.putBoolean(packageName + HAS_RATED, true);
                    AppRate.apply(editor);
                }
            } else if (appUses == uses) {
                AppRate.createAsk2RateDialogWithCustomTitle(ctx, message, rateNow, rateLater, title, 7);
                if (!reminder) {
                    editor.putBoolean(packageName + HAS_RATED, true);
                    AppRate.apply(editor);
                }
            }
        }
    }

    public static void increaseAppUsed(Context ctx) {
        String packageName = AppRate.getPackageName(ctx);
        if (packageName == null) {
            return;
        }
        SharedPreferences sp = ctx.getSharedPreferences(packageName + ALL_PREFS, 0);
        SharedPreferences.Editor editor = ctx.getSharedPreferences(packageName + ALL_PREFS, 0).edit();
        int uses = sp.getInt(packageName + APP_USES, 0);
        editor.putInt(packageName + APP_USES, ++uses);
        AppRate.apply(editor);
    }

    private static String getPackageName(Context ctx) {
        String pkgName = null;
        try {
            PackageManager manager = ctx.getPackageManager();
            PackageInfo info = manager.getPackageInfo(ctx.getPackageName(), 0);
            pkgName = info.packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return pkgName;
    }

    private static String getApplicationName(Context ctx) {
        String appName = "";
        try {
            PackageManager manager = ctx.getPackageManager();
            PackageInfo info = manager.getPackageInfo(ctx.getPackageName(), 0);
            appName = ctx.getResources().getString(info.applicationInfo.labelRes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appName;
    }

    private static void createAsk2RateDialogWithCustomTitle(final Context ctx, String message, String rateNow, String rateLater, String title, int daysLater) {
        AlertDialog.Builder marketDialog = new AlertDialog.Builder(ctx);
        final String packageName = AppRate.getPackageName(ctx);
        String appName = AppRate.getApplicationName(ctx);
        final String marketLink = "market://details?id=" + packageName;
        marketDialog.setTitle((CharSequence)title);
        marketDialog.setMessage((CharSequence)message);
        marketDialog.setPositiveButton((CharSequence)rateNow, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                Uri uri = Uri.parse((String)marketLink);
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                ctx.startActivity(intent);
                dialog.dismiss();
                SharedPreferences.Editor editor = ctx.getSharedPreferences(packageName + AppRate.ALL_PREFS, 0).edit();
                editor.putBoolean(packageName + AppRate.HAS_RATED, true);
                AppRate.apply(editor);
            }
        }).setNegativeButton((CharSequence)rateLater, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SharedPreferences.Editor editor = ctx.getSharedPreferences(packageName + AppRate.ALL_PREFS, 0).edit();
                editor.putLong(packageName + AppRate.INSTALL_DATE, System.currentTimeMillis());
                AppRate.apply(editor);
                dialog.cancel();
            }
        });
        marketDialog.create().show();
    }

    private static void createAsk2RateDialog(final Context ctx, String message, String rateNow, String rateLater) {
        AlertDialog.Builder marketDialog = new AlertDialog.Builder(ctx);
        final String packageName = AppRate.getPackageName(ctx);
        String appName = AppRate.getApplicationName(ctx);
        final String marketLink = "market://details?id=" + packageName;
        marketDialog.setTitle((CharSequence)("Rate " + appName));
        marketDialog.setMessage((CharSequence)message);
        marketDialog.setPositiveButton((CharSequence)rateNow, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                Uri uri = Uri.parse((String)marketLink);
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                ctx.startActivity(intent);
                dialog.dismiss();
                SharedPreferences.Editor editor = ctx.getSharedPreferences(packageName + AppRate.ALL_PREFS, 0).edit();
                editor.putBoolean(packageName + AppRate.HAS_RATED, true);
                AppRate.apply(editor);
            }
        }).setNegativeButton((CharSequence)rateLater, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });
        marketDialog.create().show();
    }

    public static void createAlertNow(Context ctx, String message, String rateNow, String rateLater, String title, int dayslater) {
        AppRate.createAsk2RateDialogWithCustomTitle(ctx, message, rateNow, rateLater, title, dayslater);
    }

    private static Method findApplyMethod() {
        try {
            Class<SharedPreferences.Editor> cls = SharedPreferences.Editor.class;
            return cls.getMethod("apply", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static void apply(SharedPreferences.Editor editor) {
        if (sApplyMethod != null) {
            try {
                sApplyMethod.invoke((Object)editor, new Object[0]);
                return;
            }
            catch (InvocationTargetException unused) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        editor.commit();
    }
}

