/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core.networking.encoding;

import com.testflightapp.lib.core.Logger;
import com.testflightapp.lib.core.networking.encoding.IParameterEncoder;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;

public class JSONParameterEncoder
implements IParameterEncoder {
    @Override
    public HttpEntity encode(Map<String, Object> map) {
        if (map == null) {
            Logger.e("null passed to JSONParameterEncoder.encode");
            throw new NullPointerException("Cannot encode null parameters");
        }
        String string = this.encodeToString(map);
        try {
            return new StringEntity(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.wtf("Error converting a String to a StringEntity", unsupportedEncodingException);
            throw new RuntimeException("Exception converting String to StringEntity");
        }
    }

    private String encodeToString(Map<String, Object> map) {
        String string = "{";
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            Object object = map.get(string2);
            string = string + "\"" + string2 + "\": ";
            string = string + this.encodeValue(object);
            if (i + 1 >= objectArray.length) continue;
            string = string + ',';
        }
        string = string + '}';
        return string;
    }

    private String encodeValue(Object object) {
        String string = "";
        if (object == null) {
            string = string + "null";
        } else if (object instanceof String) {
            string = string + '\"' + (String)object + '\"';
        } else if (object instanceof Map) {
            string = string + this.encodeToString((Map)object);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            string = string + '[';
            for (int i = 0; i < objectArray.length; ++i) {
                string = string + this.encodeValue(objectArray[i]);
                if (i + 1 >= objectArray.length) continue;
                string = string + ',';
            }
            string = string + ']';
        } else if (object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean) {
            string = string + object.toString();
        } else {
            String string2 = "Invalid parameter type " + object.getClass().toString() + " passed to JSONParameterEncoder.encode";
            Logger.w(string2);
            throw new RuntimeException(string2);
        }
        return string;
    }
}

