/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import com.testflightapp.lib.core.Logger;
import com.testflightapp.lib.events.SessionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SqliteObjectPersistor<T extends SessionEvent>
extends SQLiteOpenHelper {
    public static final int MAX_IN_MEMORY_EVENTS = 50;
    private static final String TABLE_EVENT = "event";
    private static final String TABLE_BUNDLE_INFO = "bundle_info";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_HASH = "hash";
    private static final String COLUMN_DATA = "data";
    private static final String COLUMN_BUNDLE_INFO_ID = "bundle_info_id";
    private static final int OBJECTDB_VERSION = 2;
    private static final String TABLE_CREATE_STATEMENT_EVENT = "CREATE TABLE IF NOT EXISTS event (id INTEGER PRIMARY KEY AUTOINCREMENT, bundle_info_id INTEGER NOT NULL, data BLOB NOT NULL);";
    private static final String TABLE_CREATE_STATEMENT_BUNDLE_INFO = "CREATE TABLE IF NOT EXISTS bundle_info (id INTEGER PRIMARY KEY AUTOINCREMENT, hash VARCHAR NOT NULL, data BLOB NOT NULL);";
    private static final String TAG = SqliteObjectPersistor.class.getSimpleName();
    private SQLiteDatabase mDB = this.getWritableDatabase();
    private long mBundleInfoId;
    private List<T> mEvents;

    public SqliteObjectPersistor(Context context, String string, Map<String, Object> map) throws IOException {
        super(context, string, null, 2);
        int n;
        String string2 = this.getBundleInfoHash(map);
        Cursor cursor = this.mDB.query(TABLE_BUNDLE_INFO, null, "hash = '" + string2 + "'", null, null, null, null, "1");
        if (cursor.getCount() > 0) {
            cursor.moveToNext();
            int n2 = cursor.getColumnIndex(COLUMN_ID);
            this.mBundleInfoId = cursor.getInt(n2);
        } else {
            ContentValues contentValues = new ContentValues(2);
            contentValues.put(COLUMN_HASH, string2);
            contentValues.put(COLUMN_DATA, SqliteObjectPersistor.getSerializedmObject(map));
            Logger.d(TAG, "Will try to persist bundle info");
            this.mBundleInfoId = this.mDB.insert(TABLE_BUNDLE_INFO, null, contentValues);
            if (this.mBundleInfoId != -1L) {
                Logger.d(TAG, "Did persist bundle info. ID: " + this.mBundleInfoId);
            } else {
                Logger.e(TAG, "Did fail to persist bundle info. Bundle info: " + map.toString());
            }
        }
        cursor = this.mDB.query(TABLE_BUNDLE_INFO, null, "hash != '" + string2 + "'", null, null, null, null, null);
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        if (cursor.getCount() > 0) {
            n = cursor.getColumnIndex(COLUMN_ID);
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                long l = cursor.getLong(n);
                Cursor cursor2 = this.mDB.query(TABLE_EVENT, null, "bundle_info_id = " + l, null, null, null, null);
                if (cursor2.getCount() == 0) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l);
                    ++n3;
                }
                cursor2.close();
                cursor.moveToNext();
            }
        }
        cursor.close();
        if (stringBuilder.length() > 0) {
            Logger.d(TAG, "Will try to delete " + n3 + " unused bundle info from the db. ID: " + stringBuilder.toString());
            n = this.mDB.delete(TABLE_BUNDLE_INFO, "id IN (" + stringBuilder.toString() + ")", null);
            if (n > 0) {
                Logger.d(TAG, "Did delete " + n + " unused bundle info from the db.");
            }
        }
        this.mEvents = this.loadEventsIntoMemory(this.mDB, TABLE_EVENT);
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        try {
            sQLiteDatabase.execSQL(TABLE_CREATE_STATEMENT_EVENT);
            sQLiteDatabase.execSQL(TABLE_CREATE_STATEMENT_BUNDLE_INFO);
        }
        catch (SQLiteException sQLiteException) {
            Logger.e("Error creating database", sQLiteException);
            throw sQLiteException;
        }
    }

    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        try {
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS event");
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS bundle_info");
            sQLiteDatabase.execSQL(TABLE_CREATE_STATEMENT_EVENT);
            sQLiteDatabase.execSQL(TABLE_CREATE_STATEMENT_BUNDLE_INFO);
        }
        catch (SQLiteException sQLiteException) {
            Logger.e("Error upgrading database", sQLiteException);
            throw sQLiteException;
        }
    }

    private synchronized List<T> loadEventsIntoMemory(SQLiteDatabase sQLiteDatabase, String string) throws IOException {
        int n = 50;
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query(string, null, null, null, null, null, null, String.valueOf(n));
        }
        catch (SQLException sQLException) {
            Logger.wtf("Database can not be opened", sQLException);
        }
        ArrayList<T> arrayList = new ArrayList<T>(n);
        if (cursor == null || cursor.getCount() == 0) {
            return arrayList;
        }
        int n2 = cursor.getColumnIndex(COLUMN_ID);
        int n3 = cursor.getColumnIndex(COLUMN_BUNDLE_INFO_ID);
        int n4 = cursor.getColumnIndex(COLUMN_DATA);
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            int n5 = cursor.getInt(n2);
            long l = cursor.getLong(n3);
            T t = this.getDeserializedObject(cursor.getBlob(n4));
            if (t != null) {
                ((SessionEvent)t).setPersistentId(n5);
                ((SessionEvent)t).setBundleInfoPersistenceId(l);
                arrayList.add(t);
            }
            cursor.moveToNext();
        }
        cursor.close();
        return arrayList;
    }

    private synchronized List<T> loadEventsIntoMemoryeSafely(SQLiteDatabase sQLiteDatabase, String string) {
        List<T> list = null;
        try {
            list = this.loadEventsIntoMemory(sQLiteDatabase, string);
        }
        catch (IOException iOException) {
            Logger.wtf("Did fail to load events from database", iOException);
        }
        return list;
    }

    private synchronized List<T> loadEventsIntoMemoryeSafely(String string) {
        List<T> list = null;
        try {
            return this.loadEventsIntoMemoryeSafely(this.mDB, string);
        }
        catch (SQLException sQLException) {
            Logger.wtf("Database can not be opened", sQLException);
            return list;
        }
    }

    private T getDeserializedObject(byte[] byArray) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            SessionEvent sessionEvent = (SessionEvent)objectInputStream.readObject();
            objectInputStream.close();
            return (T)sessionEvent;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.wtf("Unknown class de-serializing object", classNotFoundException);
        }
        catch (Throwable throwable) {
            Logger.e("Error adding item from SQLite cache.", throwable);
        }
        return null;
    }

    private Map<String, Object> getDeserializedMap(byte[] byArray) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            Map map = (Map)objectInputStream.readObject();
            objectInputStream.close();
            return map;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.wtf("Unknown class de-serializing object", classNotFoundException);
        }
        catch (Throwable throwable) {
            Logger.e("Error adding item from SQLite cache.", throwable);
        }
        return null;
    }

    public synchronized int persistEvent(T t) {
        byte[] byArray = SqliteObjectPersistor.getSerializedmObject(t);
        if (byArray == null) {
            return 0;
        }
        try {
            ContentValues contentValues = new ContentValues(1);
            contentValues.put(COLUMN_DATA, byArray);
            contentValues.put(COLUMN_BUNDLE_INFO_ID, Long.valueOf(this.mBundleInfoId));
            Logger.d(TAG, "Will try to persist event to db.");
            long l = this.mDB.insert(TABLE_EVENT, null, contentValues);
            if (l != -1L) {
                Logger.d(TAG, "Did persist event to db. ID: " + l);
                ((SessionEvent)t).setPersistentId(l);
                ((SessionEvent)t).setBundleInfoPersistenceId(this.mBundleInfoId);
                if (this.mEvents.size() < 50) {
                    this.mEvents.add(t);
                }
                return 1;
            }
            Logger.e(TAG, "Did fail to persist event to db. Event: " + t);
        }
        catch (Exception exception) {
            Logger.wtf("Database can not be opened", exception);
        }
        return 0;
    }

    public synchronized int persistEvents(T[] TArray) {
        int n = 0;
        for (T t : TArray) {
            n += this.persistEvent(t);
        }
        return n;
    }

    public synchronized int persistEvents(List<T> list) {
        int n = 0;
        for (SessionEvent sessionEvent : list) {
            n += this.persistEvent(sessionEvent);
        }
        return n;
    }

    public synchronized int removeEvents(T[] TArray) {
        String string = SqliteObjectPersistor.getIdsString(TArray);
        if (string.length() != 0) {
            Logger.d(TAG, "Will try to delete " + TArray.length + " events from the db. ID: " + string);
            int n = this.removeEventsFromDatabase(string);
            this.mEvents.removeAll(Arrays.asList(TArray));
            if (n != TArray.length) {
                Logger.d(TAG, "Failed to delete " + (TArray.length - n) + " events from the db.");
                Logger.wtf(TAG, "Error keeping data in sync with db.");
            } else {
                Logger.d(TAG, "Did delete " + n + " events " + string + " from the db.");
            }
            this.mEvents = this.loadEventsIntoMemoryeSafely(TABLE_EVENT);
            return n;
        }
        return -1;
    }

    private static <T extends SessionEvent> String getIdsString(T[] TArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (T t : TArray) {
            long l = ((SessionEvent)t).getPersistentId();
            if (l == -1L) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(String.valueOf(l));
        }
        return stringBuilder.toString();
    }

    private int removeEventsFromDatabase(String string) {
        try {
            return this.mDB.delete(TABLE_EVENT, "id IN (" + string + ")", null);
        }
        catch (Exception exception) {
            Logger.wtf("Database can not be opened", exception);
            return 0;
        }
    }

    public synchronized int getEventCount() {
        return this.mEvents.size();
    }

    public synchronized T getEvent(int n) {
        return (T)((SessionEvent)this.mEvents.get(n));
    }

    public synchronized Map<String, Object> getBundleInfoForEvent(T t) {
        Cursor cursor;
        try {
            cursor = this.mDB.query(TABLE_BUNDLE_INFO, null, "id = " + ((SessionEvent)t).getBundleInfoPersistenceId(), null, null, null, null, "1");
        }
        catch (SQLException sQLException) {
            Logger.wtf("Database can not be opened", sQLException);
            return null;
        }
        if (cursor.getCount() == 0) {
            return null;
        }
        int n = cursor.getColumnIndex(COLUMN_DATA);
        cursor.moveToFirst();
        Map<String, Object> map = this.getDeserializedMap(cursor.getBlob(n));
        cursor.close();
        return map;
    }

    protected String getBundleInfoHash(Map<String, Object> map) {
        return SqliteObjectPersistor.md5(map.toString());
    }

    private static final String md5(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                String string2 = Integer.toHexString(0xFF & byArray[i]);
                while (string2.length() < 2) {
                    string2 = "0" + string2;
                }
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return "";
        }
    }

    private static byte[] getSerializedmObject(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Logger.wtf("Did fail to serialize object", iOException);
            return null;
        }
    }

    public synchronized void clearEvents() {
        Logger.d(TAG, "Will delete " + this.mEvents.size() + " events from memory cache.");
        this.mEvents.clear();
        Logger.d(TAG, "Did delete events from memory cache.");
        try {
            Logger.d(TAG, "Will delete events from db.");
            int n = this.mDB.delete(TABLE_EVENT, null, null);
            Logger.d(TAG, "Did delete " + n + " events from db.");
        }
        catch (Exception exception) {
            Logger.wtf("Database can not be opened", exception);
        }
    }
}

