/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Process;
import android.telephony.TelephonyManager;
import com.testflightapp.lib.DeviceIDs;
import com.testflightapp.lib.core.StringUtils;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class DeviceInfo {
    private static final int DEVICE_TYPE_PHONE = 0;
    private static final int DEVICE_TYPE_TABLET = 1;

    private static boolean isPermissionGranted(Context context, String string) {
        return context.checkPermission(string, Process.myPid(), Process.myUid()) == 0;
    }

    private static boolean isIDValid(String string) {
        return string != null && string.length() != 0 && !string.equals("000000000000000") && !string.equals("0") && !string.equals("unknown");
    }

    public static String getCarrier(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String string = telephonyManager.getNetworkOperatorName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String getLocale() {
        return Locale.getDefault().toString();
    }

    public static String getSystemName() {
        return "Android OS";
    }

    public static String getOSVersionName() {
        return Build.VERSION.RELEASE;
    }

    public static String getLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public static String getMacAddressSha1(Context context) {
        if (DeviceInfo.isPermissionGranted(context, "android.permission.ACCESS_WIFI_STATE")) {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            String string = wifiManager.getConnectionInfo().getMacAddress();
            return StringUtils.sha1(string);
        }
        return null;
    }

    public static int getAPILevel() {
        return Build.VERSION.SDK_INT;
    }

    @TargetApi(value=9)
    public static int getDeviceType(Context context) {
        boolean bl;
        int n = context.getResources().getConfiguration().screenLayout & 0xF;
        boolean bl2 = Build.VERSION.SDK_INT >= 9 && n == 4;
        boolean bl3 = bl = n == 3;
        if (bl2 || bl) {
            return 1;
        }
        return 0;
    }

    public static String getModel() {
        return Build.MODEL;
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getTimeZone() {
        return TimeZone.getDefault().getDisplayName(false, 0);
    }

    public static int getTimeZoneOffset() {
        return TimeZone.getDefault().getRawOffset() / 1000;
    }

    public static String getConnectionState(Context context) {
        if (DeviceInfo.isPermissionGranted(context, "android.permission.ACCESS_NETWORK_STATE")) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.isConnected()) {
                return "wifi";
            }
            NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(0);
            if (networkInfo2 != null && networkInfo2.isConnected()) {
                return "mobile";
            }
            return "unknown";
        }
        return null;
    }

    static void pack(Context context, Map<String, Object> map) {
        map.put("carrier", DeviceInfo.getCarrier(context));
        map.put("locale", DeviceInfo.getLocale());
        map.put("system_name", DeviceInfo.getSystemName());
        map.put("os_version", DeviceInfo.getOSVersionName());
        map.put("language", DeviceInfo.getLanguage());
        map.put("device_model", DeviceInfo.getModel());
        map.put("device_manufacturer", DeviceInfo.getManufacturer());
        map.put("time_zone", DeviceInfo.getTimeZone());
        map.put("time_zone_offset", DeviceInfo.getTimeZoneOffset());
        map.put("device_type", DeviceInfo.getDeviceType(context));
        map.put("api_level", DeviceInfo.getAPILevel());
        map.put("platform", "android");
        map.put("open_udid", DeviceIDs.getOpenUDID(context));
        DeviceInfo.setIfNotNull(map, "connection_state", DeviceInfo.getConnectionState(context));
        DeviceInfo.setIfNotNull(map, "mac_address_sha1", DeviceInfo.getMacAddressSha1(context));
        DeviceInfo.setIfNotNull(map, "android_id", DeviceIDs.getAndroidID(context));
    }

    private static void setIfNotNull(Map<String, Object> map, String string, String string2) {
        if (string2 != null) {
            map.put(string, string2);
        }
    }
}

