/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import android.os.Process;
import android.provider.Settings;
import com.testflightapp.lib.core.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Properties;

public class DeviceIDs {
    private static String sOpenUDID = null;
    private static final String OPEN_UDID_KEY = "openudid";
    private static final String TF_PREFERENCES = "TestFlightID";
    private static final String OPEN_UDID_SD_FILE = "deviceidentifier.properties";
    private static final String OPEN_UDID_SD_FILE_DIR = "Android";

    public static synchronized String getAndroidID(Context context) {
        String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return string == null || string.equals("9774d56d682e549c") || string.equals("0000000000000000") || string.length() < 15 ? null : string;
    }

    public static synchronized String getOpenUDID(Context context) {
        if (sOpenUDID != null) {
            return sOpenUDID;
        }
        sOpenUDID = DeviceIDs.getAndroidID(context);
        if (sOpenUDID != null) {
            Logger.d("Open UDID is set to Android ID: " + sOpenUDID);
            return sOpenUDID;
        }
        sOpenUDID = DeviceIDs.getSdCardUdid(context);
        if (sOpenUDID != null) {
            Logger.d("Open UDID from external storage: " + sOpenUDID);
            return sOpenUDID;
        }
        sOpenUDID = DeviceIDs.getPreferencesUdid(context);
        if (sOpenUDID != null) {
            Logger.d("Open UDID from SharedPreferences: " + sOpenUDID);
            return sOpenUDID;
        }
        sOpenUDID = DeviceIDs.getGeneratedUdid();
        Logger.d("Generated Open UDID: " + sOpenUDID);
        DeviceIDs.storeOpenUDID(context, sOpenUDID);
        return sOpenUDID;
    }

    static String getGeneratedUdid() {
        SecureRandom secureRandom = new SecureRandom();
        return new BigInteger(64, secureRandom).toString(16);
    }

    static String getPreferencesUdid(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(TF_PREFERENCES, 0);
        return sharedPreferences.getString(OPEN_UDID_KEY, null);
    }

    static String getSdCardUdid(Context context) {
        File file;
        if (DeviceIDs.isExternalStorageReadable(context) && (file = new File(Environment.getExternalStorageDirectory() + "/" + OPEN_UDID_SD_FILE_DIR, OPEN_UDID_SD_FILE)).exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(file));
                String string = properties.getProperty(OPEN_UDID_KEY);
                if (string != null && string.length() > 15) {
                    return string;
                }
            }
            catch (IOException iOException) {
                Logger.e("Error loading properties from file " + file.getAbsolutePath(), iOException);
                if (file.delete()) {
                    System.out.println(file.getName() + " deleted.");
                }
                System.out.println("Delete of " + file.getName() + " failed.");
            }
        }
        return null;
    }

    static void storeOpenUDID(Context context, String string) {
        Object object;
        if (DeviceIDs.isExternalStorageWritable(context)) {
            object = new File(Environment.getExternalStorageDirectory() + "/" + OPEN_UDID_SD_FILE_DIR);
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
            File file = new File((File)object, OPEN_UDID_SD_FILE);
            Properties properties = new Properties();
            properties.setProperty(OPEN_UDID_KEY, string);
            try {
                properties.store(new FileOutputStream(file), "ID used to uniquely identify device. DO NOT DELETE.");
            }
            catch (IOException iOException) {
                Logger.e("Error writing properties to file " + file.getAbsolutePath(), iOException);
            }
        }
        object = context.getSharedPreferences(TF_PREFERENCES, 0);
        object.edit().putString(OPEN_UDID_KEY, string).commit();
    }

    static boolean isExternalStorageWritable(Context context) {
        return context.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", Process.myPid(), Process.myUid()) == 0 && DeviceIDs.isSdCardMounted();
    }

    static boolean isExternalStorageReadable(Context context) {
        return context.checkPermission("android.permission.READ_EXTERNAL_STORAGE", Process.myPid(), Process.myUid()) == 0 && (DeviceIDs.isSdCardMountedReadOnly() || DeviceIDs.isSdCardMounted());
    }

    static boolean isSdCardMounted() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    static boolean isSdCardMountedReadOnly() {
        return "mounted_ro".equals(Environment.getExternalStorageState());
    }

    static void clearOpenUdidFromMemory() {
        sOpenUDID = null;
    }
}

