package com.bzutils;

import android.app.Activity;
import android.os.AsyncTask;
import android.os.Bundle;

import com.bzutils.facebook.DialogError;
import com.bzutils.facebook.Facebook;
import com.bzutils.facebook.FacebookError;
import com.bzutils.listener.ContactsListener;
import com.bzutils.model.Contact;

import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

/**
 * Created by iaguila on 19/07/13.
 */
class FacebookMethods {

    private static ContactsListener facebookContactsListener;

    public static void getFacebookContacts(Activity ctx, String facebookId, ContactsListener listener){
        facebookContactsListener = listener;
        final Facebook facebook = new Facebook(facebookId);
        facebook.authorize(ctx, new String[] { "email", "read_stream","read_friendlists","manage_friendlists","publish_stream", "offline_access" },

                Facebook.FORCE_DIALOG_AUTH , new Facebook.DialogListener() {
            @Override
            public void onComplete(Bundle values) {
                new getContactsFromFacebook().execute(facebook.getAccessToken());
            }

            @Override
            public void onFacebookError(FacebookError error) {
                if (facebookContactsListener != null)
                    facebookContactsListener.onContactsFailed(error.getMessage());
            }

            @Override
            public void onError(DialogError e) {
                if (facebookContactsListener != null)
                    facebookContactsListener.onContactsFailed(e.getMessage());
            }

            @Override
            public void onCancel() {
                if (facebookContactsListener != null)
                    facebookContactsListener.onContactsFailed("Action cancelled");
            }
        }
        );


    }
    private static class getContactsFromFacebook extends AsyncTask<String, Void, JSONObject> {
        String token ="";
        protected void onPreExecute() {

        }
        @Override
        protected JSONObject doInBackground(String... arg0) {
            token = arg0[0];
            InputStream is = null;
            String result = "";
            JSONObject jArray = null;
            try
            {
                HttpClient httpclient = new DefaultHttpClient();
                HttpGet httppost = new HttpGet("https://graph.facebook.com/me/friends?access_token=" + token);

                org.apache.http.HttpResponse response = httpclient.execute(httppost);
                HttpEntity entity = response.getEntity();
                is = entity.getContent();
            }
            catch(Exception e)
            {
                LogBZ.getInstance().printStackTrace(e);
            }
            //convert response to string
            try
            {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is),8);
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null)
                {
                    sb.append(line + "\n");
                }
                is.close();
                result=sb.toString();
                LogBZ.getInstance().e("RESULT" + result);
            }
            catch(Exception e)
            {
                LogBZ.getInstance().printStackTrace(e);
            }

            //try parse the string to a JSON object
            try
            {
                jArray = new JSONObject(result);

            }
            catch(JSONException e)
            {
                LogBZ.getInstance().printStackTrace(e);
            }
            // TODO Auto-generated method stub

            return jArray;
        }

        protected void onPostExecute(JSONObject st) {

            try {
                parseFriends(st);
            } catch (JSONException e) {
                // TODO Auto-generated catch block
                if (facebookContactsListener != null)
                    facebookContactsListener.onContactsFailed(e.getMessage());
            }
        }
    }

    private static void parseFriends(JSONObject jArray) throws JSONException {
        ArrayList<Contact> contactsFB = new ArrayList<Contact>();
        JSONArray arr = new JSONArray(jArray.getString("data"));
        for(int i=0;i < arr.length();i++){
            try {
                Contact contacto = new Contact();
                contacto.setName(arr.getJSONObject(i).optString("name"));
                contacto.setId(arr.getJSONObject(i).optString("id"));
                contacto.setUrlFoto("https://graph.facebook.com/"+contacto.getId()+"/picture");
                contactsFB.add(contacto);
            } catch (JSONException e) {
                // TODO Auto-generated catch block
                facebookContactsListener.onContactsFailed(e.getMessage());
            }
        }

        if (facebookContactsListener != null)
            facebookContactsListener.onContactsReceived(contactsFB);
    }
}
