/*
 * Decompiled with CFR 0.152.
 */
package net.mm2d.log.android;

import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import androidx.annotation.NonNull;
import net.mm2d.log.Log;

public class SingleThreadLogPrint {
    @NonNull
    public static Log.Print get() {
        return SingleThreadPrintImpl.getInstance();
    }

    private static class SingleThreadPrintImpl
    implements Log.Print {
        @NonNull
        private static final SingleThreadPrintImpl INSTANCE = new SingleThreadPrintImpl();
        @NonNull
        private final Handler mHandler;

        @NonNull
        static SingleThreadPrintImpl getInstance() {
            return INSTANCE;
        }

        private SingleThreadPrintImpl() {
            HandlerThread thread = new HandlerThread("logging");
            thread.start();
            this.mHandler = new Handler(thread.getLooper());
        }

        public void println(int level, @NonNull String tag, @NonNull String message) {
            this.mHandler.post(() -> this.printlnInner(level, tag, message));
        }

        private void printlnInner(int level, @NonNull String tag, @NonNull String message) {
            String[] lines;
            for (String line : lines = message.split("\n")) {
                Log.println((int)level, (String)tag, (String)line);
            }
        }
    }
}

