/*
 * Decompiled with CFR 0.152.
 */
package net.mm2d.log.android;

import android.support.annotation.NonNull;
import net.mm2d.log.Log;
import net.mm2d.log.android.DefaultLogPrint;
import net.mm2d.log.android.MainThreadLogPrint;
import net.mm2d.log.android.SingleThreadLogPrint;

public class AndroidLogInitializer {
    @NonNull
    public static Log.Initializer getDefault() {
        return DefaultInitializer.INSTANCE;
    }

    @NonNull
    public static Log.Initializer getMainThread() {
        return MainThreadInitializer.INSTANCE;
    }

    @NonNull
    public static Log.Initializer getSingleThread() {
        return SingleThreadInitializer.INSTANCE;
    }

    private static class SingleThreadInitializer {
        private static final Log.Initializer INSTANCE = new BaseInitializer(){

            @Override
            protected Log.Print getPrint() {
                return SingleThreadLogPrint.get();
            }
        };

        private SingleThreadInitializer() {
        }
    }

    private static class MainThreadInitializer {
        private static final Log.Initializer INSTANCE = new BaseInitializer(){

            @Override
            protected Log.Print getPrint() {
                return MainThreadLogPrint.get();
            }
        };

        private MainThreadInitializer() {
        }
    }

    private static class DefaultInitializer {
        private static final Log.Initializer INSTANCE = new BaseInitializer(){

            @Override
            protected Log.Print getPrint() {
                return DefaultLogPrint.get();
            }
        };

        private DefaultInitializer() {
        }
    }

    private static abstract class BaseInitializer
    implements Log.Initializer {
        private BaseInitializer() {
        }

        public void invoke(boolean debug, boolean verbose) {
            if (debug) {
                Log.appendCaller((boolean)verbose);
                Log.appendThread((boolean)verbose);
                Log.setLogLevel((int)2);
                Log.setPrint((Log.Print)this.getPrint());
                return;
            }
            Log.appendCaller((boolean)false);
            Log.appendThread((boolean)false);
            Log.setLogLevel((int)Integer.MAX_VALUE);
            Log.setPrint((Log.Print)Log.getEmptyPrint());
        }

        protected abstract Log.Print getPrint();
    }
}

