/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Date;
import java.util.Map;
import net.minidev.asm.Accessor;
import net.minidev.asm.BeansAccess;
import net.minidev.asm.FieldFilter;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONAwareEx;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStreamAware;
import net.minidev.json.JSONStreamAwareEx;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONUtil;
import net.minidev.json.mapper.AMapper;
import net.minidev.json.mapper.CompessorMapper;
import net.minidev.json.mapper.DefaultMapper;
import net.minidev.json.mapper.DefaultMapperOrdered;
import net.minidev.json.mapper.FakeMapper;
import net.minidev.json.mapper.Mapper;
import net.minidev.json.mapper.UpdaterMapper;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public class JSONValue {
    public static JSONStyle COMPRESSION = JSONStyle.NO_COMPRESS;

    public static Object parse(InputStream in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(byte[] in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T parse(InputStream in, Class<T> mapTo) {
        try {
            JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return p.parse(in, Mapper.getMapper(mapTo));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object parse(Reader in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T parse(byte[] in, Class<T> mapTo) {
        try {
            JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return p.parse(in, Mapper.getMapper(mapTo));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parse(Reader in, Class<T> mapTo) {
        try {
            JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return p.parse(in, Mapper.getMapper(mapTo));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parse(Reader in, T toUpdate) {
        try {
            JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return p.parse(in, new UpdaterMapper<T>(toUpdate));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static <T> T parse(Reader in, AMapper<T> mapper) {
        try {
            JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return p.parse(in, mapper);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parse(String in, Class<T> mapTo) {
        try {
            JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return p.parse(in, Mapper.getMapper(mapTo));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parse(InputStream in, T toUpdate) {
        try {
            JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return p.parse(in, new UpdaterMapper<T>(toUpdate));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parse(String in, T toUpdate) {
        try {
            JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return p.parse(in, new UpdaterMapper<T>(toUpdate));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static <T> T parse(byte[] in, AMapper<T> mapper) {
        try {
            JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return p.parse(in, mapper);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static <T> T parse(String in, AMapper<T> mapper) {
        try {
            JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return p.parse(in, mapper);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object parse(String s) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(Reader in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, DefaultMapperOrdered.DEFAULT);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(String in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, DefaultMapperOrdered.DEFAULT);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String compress(String input, JSONStyle style) {
        try {
            StringBuilder sb = new StringBuilder();
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(input, new CompessorMapper(sb, style));
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return input;
        }
    }

    public static String compress(String input) {
        return JSONValue.compress(input, JSONStyle.MAX_COMPRESS);
    }

    public static String uncompress(String input) {
        return JSONValue.compress(input, JSONStyle.NO_COMPRESS);
    }

    public static Object parseWithException(byte[] in) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, DefaultMapper.DEFAULT);
    }

    public static Object parseWithException(InputStream in) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, DefaultMapper.DEFAULT);
    }

    public static Object parseWithException(Reader in) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, DefaultMapper.DEFAULT);
    }

    public static Object parseWithException(String s) throws ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(s, DefaultMapper.DEFAULT);
    }

    public static Object parseStrict(Reader in) throws IOException, ParseException {
        return new JSONParser(144).parse(in, DefaultMapper.DEFAULT);
    }

    public static Object parseStrict(String s) throws ParseException {
        return new JSONParser(144).parse(s, DefaultMapper.DEFAULT);
    }

    public static boolean isValidJsonStrict(Reader in) throws IOException {
        try {
            new JSONParser(144).parse(in, FakeMapper.DEFAULT);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJsonStrict(String s) {
        try {
            new JSONParser(144).parse(s, FakeMapper.DEFAULT);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJson(Reader in) throws IOException {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, FakeMapper.DEFAULT);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJson(String s) {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(s, FakeMapper.DEFAULT);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static void writeJSONString(Object value, Appendable out) throws IOException {
        JSONValue.writeJSONString(value, out, COMPRESSION);
    }

    public static void writeJSONString(Object value, Appendable out, JSONStyle compression) throws IOException {
        if (value == null) {
            out.append("null");
            return;
        }
        if (value instanceof String) {
            if (!compression.mustProtectValue((String)value)) {
                out.append((String)value);
            } else {
                out.append('\"');
                JSONValue.escape((String)value, out, compression);
                out.append('\"');
            }
            return;
        }
        if (value instanceof Number) {
            if (value instanceof Double) {
                if (((Double)value).isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value.toString());
                }
            } else if (value instanceof Float) {
                if (((Float)value).isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value.toString());
                }
            } else {
                out.append(value.toString());
            }
            return;
        }
        if (value instanceof Boolean) {
            out.append(value.toString());
        } else if (value instanceof JSONStreamAware) {
            if (value instanceof JSONStreamAwareEx) {
                ((JSONStreamAwareEx)value).writeJSONString(out, compression);
            } else {
                ((JSONStreamAware)value).writeJSONString(out);
            }
        } else if (value instanceof JSONAware) {
            if (value instanceof JSONAwareEx) {
                out.append(((JSONAwareEx)value).toJSONString(compression));
            } else {
                out.append(((JSONAware)value).toJSONString());
            }
        } else if (value instanceof Map) {
            JSONObject.writeJSON((Map)value, out, compression);
        } else if (value instanceof Iterable) {
            JSONArray.writeJSONString((Iterable)value, out, compression);
        } else if (value instanceof Date) {
            JSONValue.writeJSONString(value.toString(), out, compression);
        } else {
            if (value instanceof Enum) {
                String s = ((Enum)value).name();
                if (!compression.mustProtectValue(s)) {
                    out.append(s);
                } else {
                    out.append('\"');
                    JSONValue.escape(s, out, compression);
                    out.append('\"');
                }
                return;
            }
            if (value.getClass().isArray()) {
                Class<?> arrayClz = value.getClass();
                Class<?> c = arrayClz.getComponentType();
                out.append('[');
                boolean needSep = false;
                if (c.isPrimitive()) {
                    if (c == Integer.TYPE) {
                        for (int b : (int[])value) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            out.append(Integer.toString(b));
                        }
                    } else if (c == Short.TYPE) {
                        for (short b : (short[])value) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            out.append(Short.toString(b));
                        }
                    } else if (c == Byte.TYPE) {
                        for (byte b : (byte[])value) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            out.append(Integer.toString(b));
                        }
                    } else if (c == Long.TYPE) {
                        for (long b : (long[])value) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            out.append(Long.toString(b));
                        }
                    } else if (c == Float.TYPE) {
                        for (float b : (float[])value) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            out.append(Float.toString(b));
                        }
                    } else if (c == Double.TYPE) {
                        for (double b : (double[])value) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            out.append(Double.toString(b));
                        }
                    } else if (c == Boolean.TYPE) {
                        for (boolean b : (boolean[])value) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            if (b) {
                                out.append("true");
                                continue;
                            }
                            out.append("false");
                        }
                    }
                } else {
                    for (Object o : (Object[])value) {
                        if (needSep) {
                            out.append(',');
                        } else {
                            needSep = true;
                        }
                        JSONValue.writeJSONString(o, out, compression);
                    }
                }
                out.append(']');
            } else {
                Class<?> cls = value.getClass();
                boolean needSep = false;
                BeansAccess fields = BeansAccess.get(cls, (FieldFilter)JSONUtil.JSON_SMART_FIELD_FILTER);
                out.append('{');
                for (Accessor field : fields.getAccessors()) {
                    Object v = fields.get(value, field.getIndex());
                    if (needSep) {
                        out.append(',');
                    } else {
                        needSep = true;
                    }
                    JSONObject.writeJSONKV(field.getName(), v, out, compression);
                }
                out.append('}');
            }
        }
    }

    public static String toJSONString(Object value) {
        return JSONValue.toJSONString(value, COMPRESSION);
    }

    public static String toJSONString(Object value, JSONStyle compression) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONValue.writeJSONString(value, sb, compression);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String escape(String s) {
        return JSONValue.escape(s, COMPRESSION);
    }

    public static String escape(String s, JSONStyle compression) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        compression.escape(s, sb);
        return sb.toString();
    }

    public static void escape(String s, Appendable ap) {
        JSONValue.escape(s, ap, COMPRESSION);
    }

    public static void escape(String s, Appendable ap, JSONStyle compression) {
        if (s == null) {
            return;
        }
        compression.escape(s, ap);
    }
}

