/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.mapper;

import java.io.IOException;
import java.lang.reflect.Type;
import net.minidev.json.mapper.AMapper;
import net.minidev.json.mapper.Mapper;
import net.minidev.json.parser.ParseException;

public class UpdaterMapper<T>
extends AMapper<T> {
    final T obj;
    final AMapper<?> mapper;

    public UpdaterMapper(T obj) {
        if (obj == null) {
            throw new NullPointerException("can not update null Object");
        }
        this.obj = obj;
        this.mapper = Mapper.getMapper(obj.getClass());
    }

    public UpdaterMapper(T obj, Type type) {
        if (obj == null) {
            throw new NullPointerException("can not update null Object");
        }
        this.obj = obj;
        this.mapper = Mapper.getMapper(type);
    }

    @Override
    public AMapper<?> startObject(String key) throws ParseException, IOException {
        Object bean = this.mapper.getValue(this.obj, key);
        if (bean == null) {
            return this.mapper.startObject(key);
        }
        return new UpdaterMapper<Object>(bean, this.mapper.getType(key));
    }

    @Override
    public AMapper<?> startArray(String key) throws ParseException, IOException {
        return this.mapper.startArray(key);
    }

    @Override
    public void setValue(Object current, String key, Object value) throws ParseException, IOException {
        this.mapper.setValue(current, key, value);
    }

    @Override
    public void addValue(Object current, Object value) throws ParseException, IOException {
        this.mapper.addValue(current, value);
    }

    @Override
    public Object createObject() {
        if (this.obj != null) {
            return this.obj;
        }
        return this.mapper.createObject();
    }

    @Override
    public Object createArray() {
        if (this.obj != null) {
            return this.obj;
        }
        return this.mapper.createArray();
    }

    @Override
    public T convert(Object current) {
        if (this.obj != null) {
            return this.obj;
        }
        return (T)this.mapper.convert(current);
    }
}

