package net.minidev.json.parser;

/**
 * @author Uriel Chemouni <uchemouni@gmail.com>
 * 
 * @see JSONParser
 * @see JSONParserStream
 */
public class JSONParserBase {
	protected ContainerFactory containerFactory;
	//protected StringBuilder sb = new StringBuilder();
	protected MSB sb = new MSB(15);
	protected String xs;
	protected Object xo;
	protected int pos;

	protected static boolean[] stopArray = new boolean[126];
	protected static boolean[] stopKey = new boolean[126];
	protected static boolean[] stopValue = new boolean[126];
	protected static boolean[] stopX = new boolean[126];
	static {
		stopKey[':'] = true;
		stopValue[','] = stopValue['}'] = true;
		stopArray[','] = stopArray[']'] = true;
	}

	/**
	 * smart mode, accept most of json-syntax
	 */
	public final static int MODE_PERMISSIVE = -1;

	/**
	 * Use MODE_PERMISSIVE intead of MODE_PERMISSIF
	 * 
	 * @deprecated
	 */
	public final static int MODE_PERMISSIF = -1;
	/**
	 * Parssing flags
	 */
	protected boolean acceptSimpleQuote = true;
	protected boolean acceptNonQuote = true;
	protected boolean acceptNaN = true;
	protected ContentHandler handler = ContentHandlerDumy.HANDLER;

	/**
	 * smart mode, accept most of json-syntax
	 */
	public final static int MODE_RFC4627 = 0;

	public final static int ACCEPT_SIMPLE_QUOTE = 1;
	public final static int ACCEPT_NON_QUOTE = 2;
	public final static int ACCEPT_NAN = 4;

	public void setHandler(ContentHandler handler) {
		this.handler = handler;
	}

	public JSONParserBase(int permissiveMode) {
		this.acceptNaN = (permissiveMode & ACCEPT_NAN) > 0;
		this.acceptNonQuote = (permissiveMode & ACCEPT_NON_QUOTE) > 0;
		this.acceptSimpleQuote = (permissiveMode & ACCEPT_SIMPLE_QUOTE) > 0;
	}

	public static class MSB {
		char b[];
		int p;

		public MSB(int size) {
			b = new char[size];
			p = -1;
		}

		public void append(char c) {
			p++;
			if (b.length <= p) {
				char[] t = new char[b.length * 2 + 1];
				System.arraycopy(b, 0, t, 0, b.length);
				b = t;
			}
			b[p] = c;
		}
		
		public String toString() {
			return new String(b, 0, p+1);
		}
		
		public void clear() {
			p = -1;
		} 
	}
}
