/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.actions.traverse;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.actions.path.PathDelimiter;
import net.minidev.json.actions.traverse.JSONTraverseAction;

public class LocatePathsJsonAction
implements JSONTraverseAction {
    protected List<String> pathsFound;
    protected List<String> pathsToFind;
    protected PathDelimiter delim;

    public LocatePathsJsonAction(List<String> pathsToFind, PathDelimiter delim) {
        this.pathsToFind = pathsToFind;
        this.delim = delim;
        this.pathsFound = new LinkedList<String>();
    }

    @Override
    public boolean start(JSONObject object) {
        return object != null && this.pathsToFind != null && this.pathsToFind.size() > 0;
    }

    @Override
    public boolean traverseEntry(String fullPathToEntry, Map.Entry<String, Object> entry) {
        if (!this.delim.accept(entry.getKey())) {
            return false;
        }
        this.locatePath(fullPathToEntry);
        return true;
    }

    @Override
    public boolean recurInto(String pathToEntry, JSONObject entryValue) {
        return true;
    }

    @Override
    public boolean recurInto(String pathToEntry, JSONArray entryValue) {
        return true;
    }

    @Override
    public void handleLeaf(String pathToEntry, Map.Entry<String, Object> entry) {
    }

    @Override
    public void handleLeaf(String fullPathToContainingList, int listIndex, Object listItem) {
    }

    @Override
    public boolean removeEntry(String fullPathToEntry, Map.Entry<String, Object> entry) {
        return false;
    }

    @Override
    public void end() {
    }

    @Override
    public Object result() {
        return this.pathsFound;
    }

    private void locatePath(String pathToEntry) {
        if (this.pathsToFind.contains(pathToEntry)) {
            this.pathsFound.add(pathToEntry);
        }
    }
}

