/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.actions.path;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import net.minidev.json.actions.path.PathDelimiter;

public class TreePath {
    protected final String path;
    protected List<String> keys;
    protected ListIterator<String> keysItr;
    protected String currKey;
    protected Step lastStep;
    protected StringBuilder origin;
    protected StringBuilder remainder;
    protected PathDelimiter delim;

    public TreePath(String path, PathDelimiter delim) {
        this.delim = delim;
        this.checkPath(path);
        this.path = path;
        this.keys = Arrays.asList(path.split(delim.regex()));
        this.reset();
    }

    public void reset() {
        this.keysItr = this.keys.listIterator();
        this.currKey = "";
        this.lastStep = Step.NONE;
        this.origin = new StringBuilder("");
        this.remainder = new StringBuilder(this.path);
    }

    public boolean hasNext() {
        return this.keysItr.hasNext();
    }

    public int nextIndex() {
        return this.keysItr.nextIndex();
    }

    public String next() {
        this.currKey = this.keysItr.next();
        if (!this.lastStep.equals((Object)Step.PREV)) {
            this.originIncrement();
            this.remainderDecrement();
        }
        this.lastStep = Step.NEXT;
        return this.currKey;
    }

    public boolean hasPrev() {
        return this.keysItr.hasPrevious();
    }

    public int prevIndex() {
        return this.keysItr.previousIndex();
    }

    public String prev() {
        String temp = this.currKey;
        this.currKey = this.keysItr.previous();
        if (!this.lastStep.equals((Object)Step.NEXT)) {
            this.remainderIncrement(temp);
            this.originDecrement();
        }
        this.lastStep = Step.PREV;
        return this.currKey;
    }

    private void remainderDecrement() {
        if (this.length() == 1) {
            this.remainder = new StringBuilder("");
        } else if (this.remainder.indexOf(this.delim.str()) < 0) {
            this.remainder = new StringBuilder("");
        } else {
            this.remainder.delete(0, this.remainder.indexOf(this.delim.str()) + 1);
        }
    }

    private void originDecrement() {
        if (this.length() == 1) {
            this.origin = new StringBuilder("");
        } else if (this.origin.indexOf(this.delim.str()) < 0) {
            this.origin = new StringBuilder("");
        } else {
            this.origin.delete(this.origin.lastIndexOf(this.delim.str()), this.origin.length());
        }
    }

    private void originIncrement() {
        if (this.origin.length() != 0) {
            this.origin.append(this.delim.chr());
        }
        this.origin.append(this.currKey);
    }

    private void remainderIncrement(String prev) {
        this.remainder = this.remainder.length() == 0 ? new StringBuilder(prev) : new StringBuilder(prev).append(this.delim.chr()).append((CharSequence)this.remainder);
    }

    public String path() {
        return this.path;
    }

    public String origin() {
        return this.origin.toString();
    }

    public String remainder() {
        return this.remainder.toString();
    }

    public String first() {
        return this.keys.get(0);
    }

    public String last() {
        return this.keys.get(this.keys.size() - 1);
    }

    public String curr() {
        return this.currKey;
    }

    public int length() {
        return this.keys.size();
    }

    public String subPath(int firstIndex, int lastIndex) {
        if (lastIndex < firstIndex) {
            throw new IllegalArgumentException("bad call to subPath");
        }
        StringBuilder sb = new StringBuilder(this.path.length());
        int i = firstIndex;
        while (i <= lastIndex) {
            sb.append(this.keys.get(i));
            if (i < lastIndex) {
                sb.append(this.delim.chr());
            }
            ++i;
        }
        sb.trimToSize();
        return sb.toString();
    }

    private void checkPath(String path) {
        if (path == null || path.equals("")) {
            throw new IllegalArgumentException("path cannot be null or empty");
        }
        if (path.startsWith(this.delim.str()) || path.endsWith(this.delim.str()) || path.contains(String.valueOf(this.delim.str()) + this.delim.str())) {
            throw new IllegalArgumentException(String.format("path cannot start or end with %s or contain '%s%s'", this.delim.str(), this.delim.str(), this.delim.str()));
        }
    }

    public TreePath clone() throws CloneNotSupportedException {
        TreePath cloned = new TreePath(this.path, this.delim);
        while (cloned.nextIndex() != this.nextIndex()) {
            cloned.next();
        }
        if (cloned.prevIndex() != this.prevIndex()) {
            cloned.prev();
        }
        cloned.lastStep = this.lastStep;
        cloned.currKey = new String(this.currKey);
        cloned.origin = new StringBuilder(this.origin);
        cloned.remainder = new StringBuilder(this.remainder);
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreePath treePath = (TreePath)o;
        return this.path().equals(treePath.path()) && this.hasNext() == treePath.hasNext() && this.hasPrev() == treePath.hasPrev() && this.curr().equals(treePath.curr()) && this.origin().equals(treePath.origin()) && this.remainder().equals(treePath.remainder()) && this.lastStep == treePath.lastStep && this.delim.equals(treePath.delim);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.keys.hashCode();
        result = 31 * result + this.keysItr.hashCode();
        result = 31 * result + this.currKey.hashCode();
        result = 31 * result + this.lastStep.hashCode();
        result = 31 * result + this.origin.hashCode();
        result = 31 * result + this.remainder.hashCode();
        result = 31 * result + this.delim.hashCode();
        return result;
    }

    protected static enum Step {
        NONE,
        NEXT,
        PREV;

    }
}

