/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.asm;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minidev.asm.ASMUtil;
import net.minidev.asm.Accessor;
import net.minidev.asm.BeansAccessBuilder;
import net.minidev.asm.DefaultConverter;
import net.minidev.asm.DynamicClassLoader;
import net.minidev.asm.FieldFilter;

public abstract class BeansAccess<T> {
    private HashMap<String, Accessor> map;
    private Accessor[] accs;
    private static ConcurrentHashMap<Class<?>, BeansAccess<?>> cache = new ConcurrentHashMap();

    protected void setAccessor(Accessor[] accs) {
        int i = 0;
        this.accs = accs;
        this.map = new HashMap();
        for (Accessor acc : accs) {
            acc.index = i++;
            this.map.put(acc.getName(), acc);
        }
    }

    public HashMap<String, Accessor> getMap() {
        return this.map;
    }

    public Accessor[] getAccessors() {
        return this.accs;
    }

    public static <P> BeansAccess<P> get(Class<P> type) {
        return BeansAccess.get(type, null);
    }

    public static <P> BeansAccess<P> get(Class<P> type, FieldFilter filter) {
        BeansAccess<?> access = cache.get(type);
        if (access != null) {
            return access;
        }
        Accessor[] accs = ASMUtil.getAccessors(type, filter);
        String accessClassName = type.getName().concat("AccAccess");
        DynamicClassLoader loader = new DynamicClassLoader(type.getClassLoader());
        Class<?> accessClass = null;
        try {
            accessClass = loader.loadClass(accessClassName);
        }
        catch (ClassNotFoundException ignored) {
            // empty catch block
        }
        if (accessClass == null) {
            BeansAccessBuilder builder = new BeansAccessBuilder(type, accs, loader);
            builder.addConversion(DefaultConverter.class);
            accessClass = builder.bulid();
        }
        try {
            BeansAccess access2 = (BeansAccess)accessClass.newInstance();
            access2.setAccessor(accs);
            cache.putIfAbsent(type, access2);
            return access2;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error constructing accessor class: " + accessClassName, ex);
        }
    }

    public abstract void set(T var1, int var2, Object var3);

    public abstract Object get(T var1, int var2);

    public abstract T newInstance();

    public void set(T object, String methodName, Object value) {
        this.set(object, this.getIndex(methodName), value);
    }

    public Object get(T object, String methodName) {
        return this.get(object, this.getIndex(methodName));
    }

    public int getIndex(String name) {
        Accessor ac = this.map.get(name);
        if (ac == null) {
            return -1;
        }
        return ac.index;
    }
}

