/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class ZipUtil {
    private static final int buffer = 2048;

    public static void unZipFiles(File zipFile, String descDir) throws IOException {
        File pathFile = new File(descDir);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        ZipFile zip = new ZipFile(zipFile);
        Enumeration entries = zip.getEntries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = (ZipEntry)entries.nextElement();
            String zipEntryName = entry.getName();
            InputStream in = zip.getInputStream(entry);
            String outPath = (String.valueOf(descDir) + zipEntryName).replaceAll("\\*", "/");
            File file = new File((outPath = new String(outPath.getBytes("utf-8"), "ISO8859-1")).substring(0, outPath.lastIndexOf(47)));
            if (!file.exists()) {
                file.mkdirs();
            }
            if (new File(outPath).isDirectory()) continue;
            FileOutputStream out = new FileOutputStream(outPath);
            byte[] buf1 = new byte[1024];
            while ((len = in.read(buf1)) > 0) {
                ((OutputStream)out).write(buf1, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
    }

    public static void compress(String source, String destinct) throws IOException {
        List fileList = ZipUtil.loadFilename(new File(source));
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new File(destinct)));
        byte[] buffere = new byte[8192];
        int i = 0;
        while (i < fileList.size()) {
            int length;
            File file = (File)fileList.get(i);
            zos.putNextEntry((java.util.zip.ZipEntry)new ZipEntry(ZipUtil.getEntryName(source, file)));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            while ((length = bis.read(buffere)) != -1) {
                zos.write(buffere, 0, length);
            }
            bis.close();
            zos.closeEntry();
            ++i;
        }
        zos.close();
    }

    private static List loadFilename(File file) {
        ArrayList<File> filenameList = new ArrayList<File>();
        if (file.isFile()) {
            filenameList.add(file);
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                filenameList.addAll(ZipUtil.loadFilename(f));
                ++n2;
            }
        }
        return filenameList;
    }

    private static String getEntryName(String base, File file) {
        File baseFile = new File(base);
        String filename = file.getPath();
        if (baseFile.getParentFile().getParentFile() == null) {
            return filename.substring(baseFile.getParent().length());
        }
        return filename.substring(baseFile.getParent().length() + 1);
    }

    public static void unZip(String path, String savepath) {
        int count = -1;
        File file = null;
        InputStream is = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        new File(savepath).mkdir();
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(path, "gbk");
                Enumeration entries = zipFile.getEntries();
                while (entries.hasMoreElements()) {
                    byte[] buf = new byte[2048];
                    ZipEntry entry = (ZipEntry)entries.nextElement();
                    String filename = entry.getName();
                    boolean ismkdir = false;
                    if (filename.lastIndexOf("/") != -1) {
                        ismkdir = true;
                    }
                    filename = String.valueOf(savepath) + filename;
                    if (entry.isDirectory()) {
                        file = new File(filename);
                        file.mkdirs();
                        continue;
                    }
                    file = new File(filename);
                    if (!file.exists() && ismkdir) {
                        new File(filename.substring(0, filename.lastIndexOf("/"))).mkdirs();
                    }
                    file.createNewFile();
                    is = zipFile.getInputStream(entry);
                    fos = new FileOutputStream(file);
                    bos = new BufferedOutputStream(fos, 2048);
                    while ((count = is.read(buf)) > -1) {
                        ((BufferedOutputStream)bos).write(buf, 0, count);
                    }
                    ((BufferedOutputStream)bos).flush();
                    bos.close();
                    fos.close();
                    is.close();
                }
                zipFile.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                try {
                    if (bos != null) {
                        bos.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (is != null) {
                    is.close();
                }
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

