/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.util;

import com.mingsoft.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtil {
    public static String parseFirst(String source, String regex, int find) {
        String content = null;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            content = matcher.group(find);
        }
        return content;
    }

    public static List<String> parseAll(String source, String regex, int find) {
        ArrayList<String> content = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            content.add(matcher.group(find));
        }
        return content;
    }

    public static String replaceAll(String source, String regex, String newContent) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            source = matcher.replaceAll(Matcher.quoteReplacement(newContent.toString().replace("\\", "/")));
        }
        return source;
    }

    public static String replaceFirst(String source, String regex, String newContent) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            source = matcher.replaceFirst(Matcher.quoteReplacement(newContent));
        }
        return source;
    }

    public static int count(String source, String regex) {
        Pattern patternList = Pattern.compile(regex);
        Matcher matcherList = patternList.matcher(source);
        int i = 0;
        while (matcherList.find()) {
            ++i;
        }
        return i;
    }

    public static Map<String, String> doubleRegex(String globalRegex, String singleRegex, String content) {
        HashMap<String, String> map = new HashMap<String, String>();
        Pattern patternList = Pattern.compile(globalRegex);
        Matcher matcherList = patternList.matcher(content);
        while (matcherList.find()) {
            Pattern _patternList = Pattern.compile(singleRegex);
            Matcher _matcherList = _patternList.matcher(matcherList.group());
            while (_matcherList.find()) {
                if (StringUtil.isBlank(_matcherList.group(1)) || StringUtil.isBlank(_matcherList.group(2))) continue;
                map.put(_matcherList.group(1), _matcherList.group(2));
            }
        }
        return map;
    }

    public static List<Map<Integer, String>> doubleRegexToMap(String globalRegex, String singleRegex, String content, int find) {
        ArrayList<Map<Integer, String>> listAll = new ArrayList<Map<Integer, String>>();
        Pattern patternList = Pattern.compile(globalRegex);
        Matcher matcherList = patternList.matcher(content);
        while (matcherList.find()) {
            Pattern _patternList = Pattern.compile(singleRegex);
            Matcher _matcherList = _patternList.matcher(matcherList.group());
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            while (_matcherList.find()) {
                int i = 0;
                while (i < find) {
                    if (!StringUtil.isBlank(_matcherList.group(i + 1))) {
                        map.put(i, _matcherList.group(i + 1));
                    }
                    ++i;
                }
                listAll.add(map);
            }
        }
        return listAll;
    }

    public static List<String> parseAllToList(String content, String regex, int find) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            int i = 0;
            while (i < find) {
                list.add(matcher.group(i + 1));
                ++i;
            }
        }
        return list;
    }
}

