/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.util;

import com.mingsoft.util.StringUtil;
import com.mortennobel.imagescaling.ResampleOp;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.log4j.Logger;

public class ImageUtil {
    protected static Logger LOGGER = Logger.getLogger(ImageUtil.class);

    public static void batchImageWidthHeight(String directoryPath, int sSize, int tSize) {
        File dir = new File(directoryPath);
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                ImageUtil.batchImageWidthHeight(files[i].getAbsolutePath(), sSize, tSize);
            } else {
                try {
                    files[i].getPath();
                    if (ImageUtil.isPic(files[i].getPath())) {
                        BufferedImage srcImage = ImageIO.read(files[i]);
                        ImageUtil.getImageWidthHeight(srcImage, sSize, tSize);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public static void ChangeImage(String root, double scale) throws IOException {
        File file = new File(root);
        File[] subFile = file.listFiles();
        int i = 0;
        while (i < subFile.length) {
            String[] names;
            String name = subFile[i].getName();
            if (subFile[i].isDirectory()) {
                ImageUtil.ChangeImage(String.valueOf(subFile[i].getAbsolutePath()) + "\\", scale);
            }
            if (StringUtil.isBlank((names = name.split("//."))[0])) break;
            ImageUtil.scaleHyaline(String.valueOf(root) + subFile[i].getName(), String.valueOf(root) + subFile[i].getName(), scale, true);
            ++i;
        }
    }

    public static void convert(String source, String result) {
        try {
            File f = new File(source);
            f.canRead();
            f.canWrite();
            BufferedImage src = ImageIO.read(f);
            ImageIO.write((RenderedImage)src, "JPG", new File(result));
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    public static void createImage(String path, BufferedImage bi) {
        try {
            ImageIO.write((RenderedImage)bi, path.substring(path.lastIndexOf("."), path.length()).replace(".", ""), new File(path));
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }

    public static void createImage(String path, byte[] bt) {
    }

    public static void cut(String sourceImagePath, String descDir, int width, int height) {
        try {
            BufferedImage bi = ImageIO.read(new File(sourceImagePath));
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > width && srcHeight > height) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                width = 200;
                height = 150;
                int cols = 0;
                int rows = 0;
                cols = srcWidth % width == 0 ? srcWidth / width : (int)Math.floor(srcWidth / width) + 1;
                rows = srcHeight % height == 0 ? srcHeight / height : (int)Math.floor(srcHeight / height) + 1;
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < cols) {
                        CropImageFilter cropFilter = new CropImageFilter(j * 200, i * 150, width, height);
                        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                        BufferedImage tag = new BufferedImage(width, height, 1);
                        Graphics g = tag.getGraphics();
                        g.drawImage(img, 0, 0, null);
                        g.dispose();
                        ImageIO.write((RenderedImage)tag, "JPEG", new File(String.valueOf(descDir) + "pre_map_" + i + "_" + j + ".jpg"));
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void decodeImage(String sourceImagePath) {
        File file = new File(sourceImagePath);
        if (file.exists()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length = -1;
            try {
                FileInputStream is = new FileInputStream(file);
                try {
                    while ((length = ((InputStream)is).read(buffer)) != -1) {
                        baos.write(buffer, 0, length);
                    }
                    baos.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                byte[] data = baos.toByteArray();
                data[0] = -1;
                FileOutputStream os = new FileOutputStream(file);
                try {
                    ((OutputStream)os).write(data);
                    os.flush();
                    ((OutputStream)os).close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    ((InputStream)is).close();
                    baos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void encodeImage(String sourceImagePath) {
        File file = new File(sourceImagePath);
        if (file.exists()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length = -1;
            try {
                FileInputStream is = new FileInputStream(file);
                try {
                    while ((length = ((InputStream)is).read(buffer)) != -1) {
                        baos.write(buffer, 0, length);
                    }
                    baos.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                byte[] data = baos.toByteArray();
                data[0] = 0;
                FileOutputStream os = new FileOutputStream(file);
                try {
                    ((OutputStream)os).write(data);
                    os.flush();
                    ((OutputStream)os).close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    ((InputStream)is).close();
                    baos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getImageType(byte[] imageBytes) {
        ByteArrayInputStream bais = null;
        MemoryCacheImageInputStream mcis = null;
        try {
            String imageName;
            bais = new ByteArrayInputStream(imageBytes);
            mcis = new MemoryCacheImageInputStream(bais);
            Iterator<ImageReader> itr = ImageIO.getImageReaders(mcis);
            do {
                if (!itr.hasNext()) {
                    return null;
                }
                ImageReader reader = itr.next();
                imageName = reader.getClass().getSimpleName();
                if (imageName != null && "JPEGImageReader".equalsIgnoreCase(imageName)) {
                    return "jpeg";
                }
                if (imageName == null || !"JPGImageReader".equalsIgnoreCase(imageName)) continue;
                return "jpg";
            } while (imageName == null || !"pngImageReader".equalsIgnoreCase(imageName));
            return "png";
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        return null;
    }

    private static int[] getImageWidthHeight(BufferedImage source, int sourceWidth, int targetWidth) {
        double ts = (double)targetWidth / (double)sourceWidth;
        int newWidth = (int)((double)source.getWidth() * ts);
        int newHeight = (int)((double)source.getHeight() * ts);
        if (newWidth < 3) {
            newWidth = 3;
        }
        if (newHeight < 3) {
            newHeight = 3;
        }
        int[] wh = new int[]{newWidth, newHeight};
        return wh;
    }

    public static int[] getImageWidthHeight(String sourceImagePath) {
        try {
            BufferedImage bi = ImageIO.read(new File(sourceImagePath));
            int[] wh = new int[]{bi.getWidth(), bi.getHeight()};
            return wh;
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            return null;
        }
    }

    public static void gray(String sourceImagePath, String savePath) {
        try {
            BufferedImage src = ImageIO.read(new File(sourceImagePath));
            ColorSpace cs = ColorSpace.getInstance(1003);
            ColorConvertOp op = new ColorConvertOp(cs, null);
            src = op.filter(src, null);
            ImageIO.write((RenderedImage)src, "JPEG", new File(savePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean isPic(String sourceImagePath) {
        String picSfix = "jpg|png|gif";
        String[] temp = picSfix.split("\\|");
        if (sourceImagePath.indexOf(".") > 0) {
            String fileSfix = sourceImagePath.substring(sourceImagePath.indexOf("."), sourceImagePath.length()).replace(".", "");
            int i = 0;
            while (i < temp.length) {
                if (fileSfix.equals(temp[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
    }

    public static BufferedImage resize(String sourceImagePath, int width, int height) {
        try {
            BufferedImage inputBufImage = ImageIO.read(new File(sourceImagePath));
            ResampleOp resampleOp = new ResampleOp(Math.min(width, inputBufImage.getWidth()), Math.min(height, inputBufImage.getHeight()));
            BufferedImage rescaledTomato = resampleOp.filter(inputBufImage, null);
            return rescaledTomato;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static boolean resizeImage(File sourceImagePath, String savePath, int width, int height, String sufix) {
        try {
            BufferedImage inputBufImage = ImageIO.read(sourceImagePath);
            ResampleOp resampleOp = new ResampleOp(Math.min(width, inputBufImage.getWidth()), Math.min(height, inputBufImage.getHeight()));
            BufferedImage rescaledTomato = resampleOp.filter(inputBufImage, null);
            ImageIO.write((RenderedImage)rescaledTomato, sufix, new File(savePath));
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return false;
        }
    }

    public static byte[] resizeImageForBytes(String sourceImagePath, int targetW, int targetH, String type) {
        try {
            BufferedImage image = ImageUtil.resize(sourceImagePath, targetW, targetH);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, type, outStream);
            outStream.flush();
            byte[] result = outStream.toByteArray();
            outStream.close();
            return result;
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
            return null;
        }
    }

    public static boolean resizeImageForEncode(File sourceImageFile, String savePath, Integer width, Integer height, String sufix) {
        try {
            BufferedImage inputBufImage = ImageIO.read(sourceImageFile);
            ResampleOp resampleOp = new ResampleOp(Math.min(width, inputBufImage.getWidth()), Math.min(height, inputBufImage.getHeight()));
            BufferedImage rescaledTomato = resampleOp.filter(inputBufImage, null);
            ImageIO.write((RenderedImage)rescaledTomato, sufix, new File(savePath));
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return false;
        }
    }

    public static void rotate(String sourceImagePath, int direction) {
        File file = null;
        BufferedImage original = null;
        BufferedImage bufOut = null;
        file = new File(sourceImagePath);
        try {
            original = ImageIO.read(file);
        }
        catch (Exception exception) {
            return;
        }
        int width = original.getWidth();
        int height = original.getHeight();
        bufOut = new BufferedImage(width, height, original.getType());
        AffineTransform atx = new AffineTransform();
        switch (direction) {
            case 0: {
                atx.rotate(-1.5707963267948966, width / 2, height / 2);
                break;
            }
            case 1: {
                atx.rotate(1.5707963267948966, width / 2, height / 2);
            }
        }
        AffineTransformOp atop = new AffineTransformOp(atx, 3);
        atop.filter(original, bufOut);
        bufOut = bufOut.getSubimage(0, 0, width, height);
        try {
            ImageIO.write((RenderedImage)bufOut, "JPG", new File(sourceImagePath));
        }
        catch (IOException e) {
            LOGGER.debug((Object)e);
        }
    }

    public static void saveImageAsJpg(String sourceImagePath, String savePath, int width, int hight) {
        BufferedImage srcImage = null;
        String imgType = "JPEG";
        if (sourceImagePath.toLowerCase().endsWith(".png")) {
            imgType = "PNG";
        }
        File saveFile = new File(savePath);
        File fromFile = new File(sourceImagePath);
        try {
            srcImage = ImageIO.read(fromFile);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        if (width > 0 || hight > 0) {
            srcImage = ImageUtil.resize(sourceImagePath, width, hight);
        }
        try {
            ImageIO.write((RenderedImage)srcImage, imgType, saveFile);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }

    public static void scale(String sourceImagePath, String savePath, double scale, boolean flag) {
        try {
            BufferedImage src = ImageIO.read(new File(sourceImagePath));
            int width = src.getWidth();
            int height = src.getHeight();
            if (flag) {
                width = (int)((double)width * scale);
                height = (int)((double)height * scale);
            } else {
                width = (int)((double)width / scale);
                height = (int)((double)height / scale);
            }
            Image image = src.getScaledInstance(width, height, 1);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            ImageIO.write((RenderedImage)tag, "JPEG", new File(savePath));
        }
        catch (IOException e) {
            LOGGER.equals(e);
        }
    }

    public static void scaleHyaline(String sourceImagePath, String savePath, double scale, boolean flag) {
        if (ImageUtil.isPic(sourceImagePath)) {
            try {
                BufferedImage src = ImageIO.read(new File(sourceImagePath));
                BufferedImage dstImage = null;
                AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
                AffineTransformOp op = new AffineTransformOp(transform, 2);
                dstImage = op.filter(src, null);
                try {
                    ImageIO.write((RenderedImage)dstImage, "png", new File(savePath));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                LOGGER.equals(e);
            }
        }
    }

    public static void cut(int x, int y, int width, int height, String sourceImagePath, String savePath) {
        FileInputStream is = null;
        ImageInputStream iis = null;
        try {
            try {
                is = new FileInputStream(sourceImagePath);
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)("\u56fe\u7247\u672a\u627e\u5230:" + sourceImagePath));
                LOGGER.error((Object)e);
            }
            Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName("jpg");
            ImageReader reader = it.next();
            try {
                iis = ImageIO.createImageInputStream(is);
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.error((Object)("\u56fe\u7247\u672a\u627e\u5230:" + sourceImagePath));
                LOGGER.error((Object)e);
            }
            reader.setInput(iis, true);
            ImageReadParam param = reader.getDefaultReadParam();
            try {
                reader.read(0);
            }
            catch (IOException e) {
                LOGGER.error((Object)("\u56fe\u7247\u672a\u627e\u5230:" + sourceImagePath));
                LOGGER.error((Object)e);
            }
            Rectangle rect = new Rectangle(x, y, width, height);
            param.setSourceRegion(rect);
            BufferedImage bi = null;
            try {
                bi = reader.read(0, param);
            }
            catch (IOException e) {
                LOGGER.error((Object)("\u56fe\u7247\u672a\u627e\u5230:" + sourceImagePath));
                LOGGER.error((Object)e);
            }
            try {
                ImageIO.write((RenderedImage)bi, "jpg", new File(savePath));
            }
            catch (IOException e) {
                LOGGER.error((Object)("\u8f93\u51fa\u8def\u5f84\u4e0d\u6b63\u786e:" + savePath));
                LOGGER.error((Object)e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }
            if (iis != null) {
                try {
                    iis.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
    }

    public static void formatImage(String path, String fix) {
        String _path = path;
        try {
            File file = new File(_path);
            FileInputStream is = new FileInputStream(file);
            BufferedImage image = ImageIO.read(is);
            BufferedImage tag = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            tag.getGraphics().drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
            FileOutputStream newimage = new FileOutputStream(String.valueOf(path.substring(0, path.lastIndexOf("."))) + fix);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)newimage);
            encoder.encode(tag);
            newimage.close();
        }
        catch (Exception ex) {
            LOGGER.equals(ex);
        }
    }

    public static void zoom(String sourceImagePath, String savePath, int targetWidth, int targetHeight, boolean more, String exp) {
        File file = null;
        BufferedImage original = null;
        BufferedImage bufOut = null;
        if (more) {
            file = new File(sourceImagePath);
            try {
                original = ImageIO.read(file);
            }
            catch (IOException e) {
                LOGGER.debug((Object)e);
            }
            int width = original.getWidth();
            int height = original.getHeight();
            if (targetWidth >= width && targetHeight >= height) {
                targetWidth = width;
                targetHeight = height;
            }
            bufOut = new BufferedImage(width, height, original.getType());
            double xScale = new Integer(targetWidth).doubleValue() / (double)width;
            double yScale = new Integer(targetHeight).doubleValue() / (double)height;
            double scale = Math.min(xScale, yScale);
            int newWidth = new Double((double)original.getWidth() * scale).intValue();
            int newHeight = new Double((double)original.getHeight() * scale).intValue();
            AffineTransform atx = AffineTransform.getScaleInstance(scale, scale);
            AffineTransformOp atop = new AffineTransformOp(atx, 2);
            atop.filter(original, bufOut);
            bufOut = bufOut.getSubimage(0, 0, newWidth, newHeight);
            try {
                ImageIO.write((RenderedImage)bufOut, "JPG", file);
            }
            catch (IOException e) {
                LOGGER.debug((Object)e);
            }
        } else {
            if (sourceImagePath == null && sourceImagePath.length() > 0) {
                return;
            }
            String[] filePath = sourceImagePath.split(exp);
            if (filePath.length > 0) {
                int i = 0;
                while (i < filePath.length) {
                    file = new File(savePath);
                    try {
                        original = ImageIO.read(file);
                    }
                    catch (Exception exception) {
                        return;
                    }
                    int width = original.getWidth();
                    int height = original.getHeight();
                    if (targetWidth >= width && targetHeight >= height) {
                        targetWidth = width;
                        targetHeight = height;
                    }
                    bufOut = new BufferedImage(width, height, original.getType());
                    double xScale = new Integer(targetWidth).doubleValue() / (double)width;
                    double yScale = new Integer(targetHeight).doubleValue() / (double)height;
                    double scale = Math.min(xScale, yScale);
                    int newWidth = new Double((double)original.getWidth() * scale).intValue();
                    int newHeight = new Double((double)original.getHeight() * scale).intValue();
                    AffineTransform atx = AffineTransform.getScaleInstance(scale, scale);
                    AffineTransformOp atop = new AffineTransformOp(atx, 2);
                    atop.filter(original, bufOut);
                    bufOut = bufOut.getSubimage(0, 0, newWidth, newHeight);
                    try {
                        ImageIO.write((RenderedImage)bufOut, "JPG", new File(savePath));
                    }
                    catch (IOException e) {
                        LOGGER.debug((Object)e);
                    }
                    ++i;
                }
            }
        }
    }
}

