/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.util.BundleUtil;
import net.mingsoft.basic.action.BaseFileAction;
import net.mingsoft.basic.bean.UploadConfigBean;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.service.IUploadBaseService;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.cms.bean.EditorStateBean;
import net.mingsoft.mdiy.util.ConfigUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class BaseAction
extends BaseFileAction {
    protected String getResString(String key) {
        return this.getResString(key, "");
    }

    protected String getResString(String key, String ... params) {
        String str = "";
        try {
            str = super.getResString(key);
            for (int i = 0; i < params.length; ++i) {
                str = str.replace("{" + i + "}", params[i]);
            }
        }
        catch (MissingResourceException e) {
            str = BundleUtil.getString((String)"net.mingsoft.cms.resources.resources", (String)key, (String[])params);
        }
        return str;
    }

    public String exec(HttpServletRequest request, MultipartFile upfile, Map execFileConfigMap, String version) {
        String action;
        HashMap<String, String> execConfigMap = new HashMap<String, String>();
        execConfigMap.putAll(execFileConfigMap);
        AppEntity app = BasicUtil.getApp();
        String datePath = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        String uploadPath = "/".concat(app.getAppId()).concat("/editor/").concat(datePath).concat("/");
        String filePathFormat = uploadPath.concat("{time}");
        execConfigMap.put("imagePathFormat", filePathFormat);
        execConfigMap.put("filePathFormat", filePathFormat);
        execConfigMap.put("videoPathFormat", filePathFormat);
        execConfigMap.put("catcherPathFormat", filePathFormat);
        execConfigMap.put("scrawlPathFormat", filePathFormat);
        execConfigMap.put("snapscreenPathFormat", filePathFormat);
        switch (action = BasicUtil.getString((String)"action")) {
            case "uploadscrawl": {
                return this.uploadEditorScrawlFile(request, uploadPath);
            }
            case "uploadimage": 
            case "uploadvideo": 
            case "uploadfile": {
                return this.uploadEditorFile(uploadPath, upfile);
            }
            case "catchimage": {
                return this.catchImage(request, uploadPath);
            }
        }
        return this.getEditorConfig(execConfigMap, BasicUtil.getRealPath((String)StrUtil.format((CharSequence)"static/plugins/ueditor/{}/config.json", (Object[])new Object[]{version})));
    }

    private String uploadEditorScrawlFile(HttpServletRequest request, String uploadPath) {
        String base64 = request.getParameter("upfile");
        byte[] bytes = Base64.decodeBase64((String)base64);
        if (bytes == null) {
            return new EditorStateBean(false, "\u4e0a\u4f20\u6d82\u9e26\u56fe\u7247\u5931\u8d25").toString();
        }
        MultipartFile file = net.mingsoft.basic.util.FileUtil.bytesToMultipartFile((byte[])bytes, (String)"png");
        if (ObjectUtil.isNull((Object)file)) {
            return new EditorStateBean(false, "\u4e0a\u4f20\u6d82\u9e26\u56fe\u7247\u5931\u8d25").toString();
        }
        UploadConfigBean bean = new UploadConfigBean(uploadPath, file, true);
        bean.setFileSize((long)bytes.length);
        bean.setFileName(file.getName());
        EditorStateBean state = new EditorStateBean();
        try {
            state = this.uploadFile(bean);
        }
        catch (IOException e) {
            this.LOG.debug("\u4e0a\u4f20\u7f16\u8f91\u5668\u6d82\u9e26\u6587\u4ef6\u5931\u8d25");
            return new EditorStateBean(false, "\u4e0a\u4f20\u6d82\u9e26\u6587\u4ef6\u5931\u8d25").toString();
        }
        return state.toString();
    }

    private String catchImage(HttpServletRequest request, String uploadPath) {
        String[] remotes = request.getParameterValues("source[]");
        EditorStateBean multiState = new EditorStateBean(true);
        ArrayList<EditorStateBean> states = new ArrayList<EditorStateBean>();
        for (String remote : remotes) {
            String suffix;
            MultipartFile file;
            if (StringUtils.isBlank((CharSequence)remote) || (file = net.mingsoft.basic.util.FileUtil.remoteUrlToMultipartFile((String)remote, (String)(suffix = StrUtil.isBlank((CharSequence)(suffix = FileNameUtil.getSuffix((String)remote))) ? "png" : suffix))) == null) continue;
            UploadConfigBean bean = new UploadConfigBean(uploadPath, file, true);
            bean.setFileSize(file.getSize());
            bean.setFileName(file.getName());
            EditorStateBean state = new EditorStateBean();
            try {
                state = this.uploadFile(bean);
            }
            catch (IOException e) {
                this.LOG.debug("\u6293\u53d6\u56fe\u7247\u5931\u8d25");
                state = new EditorStateBean(false, "\u6293\u53d6\u56fe\u7247\u5931\u8d25");
            }
            if (state.isSuccess()) {
                state.put("state", "SUCCESS");
                state.put("source", remote);
            }
            states.add(state);
        }
        multiState.put("list", states);
        return multiState.toString();
    }

    private String uploadEditorFile(String uploadPath, MultipartFile upfile) {
        String upFileMainName = FileNameUtil.mainName((String)upfile.getOriginalFilename());
        if (StringUtils.isBlank((CharSequence)upFileMainName)) {
            return new EditorStateBean(false, this.getResString("err.error", this.getResString("file.name"))).toString();
        }
        UploadConfigBean bean = new UploadConfigBean(uploadPath, upfile, true);
        bean.setFileSize(upfile.getSize());
        bean.setFileName(upfile.getOriginalFilename());
        try {
            return this.uploadFile(bean).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EditorStateBean(false, "\u4e0a\u4f20\u56fe\u7247\u5931\u8d25").toString();
        }
    }

    private String getEditorConfig(Map configJson, String jsonPath) {
        String _configJson = FileUtil.readString((String)jsonPath, (Charset)StandardCharsets.UTF_8);
        _configJson = _configJson.replaceAll("/\\*[\\s\\S]*?\\*/", "");
        Map jsonMap = (Map)JSONUtil.toBean((String)_configJson, Map.class);
        jsonMap.putAll(configJson);
        return JSONUtil.toJsonStr((Object)jsonMap);
    }

    private EditorStateBean uploadFile(UploadConfigBean bean) throws IOException {
        String type = ConfigUtil.getString((String)"\u5b58\u50a8\u8bbe\u7f6e", (String)"storeSelect");
        IUploadBaseService uploadBaseService = null;
        EditorStateBean state = new EditorStateBean(true);
        if (StringUtils.isBlank((CharSequence)bean.getFileIdentifier())) {
            try {
                bean.setFileIdentifier(String.valueOf(Hex.encodeHex((byte[])MessageDigest.getInstance("MD5").digest(bean.getFile().getBytes()))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)type)) {
            uploadBaseService = (IUploadBaseService)SpringUtil.getBean((String)type);
        }
        ResultData resultData = null;
        resultData = uploadBaseService != null ? uploadBaseService.upload(bean) : this.upload(bean);
        if (resultData.isSuccess()) {
            state = new EditorStateBean(true);
            state.put("original", bean.getFileName());
            state.put("size", bean.getFileSize());
            state.put("title", FileNameUtil.getName((String)((String)resultData.getData(String.class))));
            state.put("type", "." + FileNameUtil.getSuffix((String)bean.getFileName()));
            state.put("fileIdentifier", bean.getFileIdentifier());
            String contextPath = BasicUtil.getContextPath();
            Object filePath = (String)resultData.getData(String.class);
            if (StringUtils.isNotBlank((CharSequence)filePath) && !((String)filePath).startsWith("http")) {
                filePath = (contextPath.equals("/") ? "" : contextPath) + (String)filePath;
            }
            state.put("url", filePath);
        } else {
            state = new EditorStateBean(false, resultData.getMsg());
        }
        return state;
    }
}

