/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateException;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.cms.action.BaseAction;
import net.mingsoft.cms.bean.CategoryBean;
import net.mingsoft.cms.bean.ContentBean;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.biz.IContentBiz;
import net.mingsoft.cms.constant.e.CategoryDisplayEnum;
import net.mingsoft.cms.constant.e.CategoryTypeEnum;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.cms.util.CmsParserUtil;
import net.mingsoft.mdiy.util.ParserUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u9759\u6001\u5316")
@Controller(value="cmsGenerater")
@RequestMapping(value={"/${ms.manager.path}/cms/generate"})
@Scope(value="request")
public class GeneraterAction
extends BaseAction {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private IContentBiz contentBiz;
    @Autowired
    private ICategoryBiz categoryBiz;
    @Value(value="${ms.diy.html-dir:html}")
    private String htmlDir;

    @GetMapping(value={"/index"})
    public String index(HttpServletRequest request, ModelMap model) {
        return "/cms/generate/index";
    }

    @Operation(summary="\u67e5\u8be2\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="categoryTitle", description="\u680f\u76ee\u7ba1\u7406\u540d\u79f0", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryParentId", description="\u7236\u7c7b\u578b\u7f16\u53f7", required=false, in=ParameterIn.QUERY)})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultData list(@ModelAttribute @Parameter(hidden=true) CategoryEntity category) {
        List categoryList = this.categoryBiz.list((Wrapper)new LambdaQueryWrapper((Object)category));
        return ResultData.build().success((Object)new EUListBean(categoryList, categoryList.size()));
    }

    @Operation(summary="\u751f\u6210\u4e3b\u9875\u63a5\u53e3")
    @RequestMapping(value={"/generateIndex"}, method={RequestMethod.GET, RequestMethod.POST})
    @RequiresPermissions(value={"cms:generate:index"})
    @LogAnn(title="\u751f\u6210\u4e3b\u9875", businessType=BusinessTypeEnum.UPDATE)
    @ResponseBody
    public ResultData generateIndex(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String tmpFileName = request.getParameter("url");
        String generateFileName = request.getParameter("position");
        if (tmpFileName.contains("..") || tmpFileName.contains("../") || tmpFileName.contains("\\..")) {
            return ResultData.build().error(this.getResString("template.file"));
        }
        if (generateFileName.contains("..") || generateFileName.contains("../") || generateFileName.contains("\\..")) {
            return ResultData.build().error(this.getResString("template.file"));
        }
        if (!FileUtil.exist((String)ParserUtil.buildTemplatePath())) {
            return ResultData.build().error(this.getResString("template.file"));
        }
        CmsParserUtil.generate(tmpFileName, generateFileName, this.htmlDir);
        return ResultData.build().success();
    }

    @Operation(summary="\u751f\u6210\u680f\u76ee\u63a5\u53e3")
    @RequestMapping(value={"/{categoryId}/generateColumn"}, method={RequestMethod.GET, RequestMethod.POST})
    @LogAnn(title="\u751f\u6210\u680f\u76ee", businessType=BusinessTypeEnum.UPDATE)
    @RequiresPermissions(value={"cms:generate:column"})
    @ResponseBody
    public ResultData generateColumn(HttpServletRequest request, HttpServletResponse response, @PathVariable String categoryId) throws IOException {
        AppEntity app = BasicUtil.getApp();
        List<Object> columns = new ArrayList();
        if ("0".equals(categoryId)) {
            categoryEntity = new CategoryEntity();
            columns = this.categoryBiz.query(categoryEntity);
        } else {
            categoryEntity = new CategoryEntity();
            categoryEntity.setId(categoryId);
            columns = this.categoryBiz.queryChildren(categoryEntity);
        }
        List<CategoryBean> articleIdList = null;
        block4: for (CategoryEntity categoryEntity : columns) {
            if (CategoryDisplayEnum.DISABLE.toString().equalsIgnoreCase(categoryEntity.getCategoryDisplay()) || categoryEntity.getCategoryType().equals(CategoryTypeEnum.LINK.toString())) continue;
            ContentBean contentBean = new ContentBean();
            contentBean.setCategoryId(categoryEntity.getId());
            contentBean.setCategoryType(categoryEntity.getCategoryType());
            articleIdList = this.contentBiz.queryIdsByCategoryIdForParser(contentBean);
            switch (CategoryTypeEnum.get(categoryEntity.getCategoryType())) {
                case LIST: {
                    if (StringUtils.isEmpty((CharSequence)categoryEntity.getCategoryListUrl()) || !FileUtil.exist((String)ParserUtil.buildTemplatePath((String)categoryEntity.getCategoryListUrl()))) {
                        this.LOG.error("{} \u6a21\u677f\u4e0d\u5b58\u5728\uff1a{}", (Object)categoryEntity.getCategoryTitle(), (Object)categoryEntity.getCategoryUrl());
                        continue block4;
                    }
                    CmsParserUtil.generateList(categoryEntity, articleIdList.size(), this.htmlDir);
                    continue block4;
                }
                case COVER: {
                    if (StringUtils.isEmpty((CharSequence)categoryEntity.getCategoryUrl()) || !FileUtil.exist((String)ParserUtil.buildTemplatePath((String)categoryEntity.getCategoryUrl()))) {
                        this.LOG.error("{} \u6a21\u677f\u4e0d\u5b58\u5728\uff1a{}", (Object)categoryEntity.getCategoryTitle(), (Object)categoryEntity.getCategoryUrl());
                        continue block4;
                    }
                    if (articleIdList.size() == 0) {
                        this.LOG.error("\u9759\u6001\u5316\u5355\u7bc7\u7c7b\u578b\u680f\u76ee\u5f02\u5e38\uff1a{} \uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u6ca1\u6709\u6587\u7ae0", (Object)categoryEntity.getCategoryTitle());
                        CategoryBean columnArticleIdBean = new CategoryBean();
                        CopyOptions copyOptions = CopyOptions.create();
                        copyOptions.setIgnoreError(true);
                        BeanUtil.copyProperties((Object)((Object)categoryEntity), (Object)((Object)columnArticleIdBean), (CopyOptions)copyOptions);
                        articleIdList.add(columnArticleIdBean);
                    }
                    CmsParserUtil.generateBasic(articleIdList, this.htmlDir, null);
                    continue block4;
                }
            }
            if (StringUtils.isEmpty((CharSequence)categoryEntity.getCategoryUrl()) || !FileUtil.exist((String)ParserUtil.buildTemplatePath((String)categoryEntity.getCategoryUrl()))) {
                this.LOG.error("{} \u6a21\u677f\u4e0d\u5b58\u5728\uff1a{}", (Object)categoryEntity.getCategoryTitle(), (Object)categoryEntity.getCategoryUrl());
                continue;
            }
            CmsParserUtil.generate(categoryEntity.getCategoryUrl(), categoryEntity.getCategoryPinyin(), this.htmlDir);
        }
        return ResultData.build().success();
    }

    @Operation(summary="\u751f\u6210\u6587\u7ae0\u63a5\u53e3")
    @RequestMapping(value={"/{columnId}/generateArticle"}, method={RequestMethod.GET, RequestMethod.POST})
    @RequiresPermissions(value={"cms:generate:article"})
    @LogAnn(title="\u751f\u6210\u6587\u7ae0", businessType=BusinessTypeEnum.UPDATE)
    @ResponseBody
    public ResultData generateArticle(HttpServletRequest request, HttpServletResponse response, @PathVariable String columnId) throws IOException {
        String dateTime = request.getParameter("dateTime");
        List<CategoryBean> articleIdList = null;
        List<Object> categoryList = new ArrayList();
        ContentBean contentBean = new ContentBean();
        contentBean.setBeginTime(dateTime);
        DateTime contentUpdateTime = null;
        try {
            contentUpdateTime = DateUtil.parse((CharSequence)dateTime);
        }
        catch (DateException e) {
            e.printStackTrace();
            return ResultData.build().error(this.getResString("err.error", this.getResString("datetime.format")));
        }
        if ("0".equals(columnId)) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().orderByAsc(CategoryEntity::getLeaf);
            categoryList = this.categoryBiz.list((Wrapper)wrapper);
        } else {
            CategoryEntity categoryEntity = new CategoryEntity();
            categoryEntity.setId(columnId);
            categoryList = this.categoryBiz.queryChildren(categoryEntity);
        }
        categoryList = categoryList.stream().filter(item -> item.getLeaf()).collect(Collectors.toList());
        for (CategoryEntity categoryEntity : categoryList) {
            if (CategoryDisplayEnum.DISABLE.toString().equalsIgnoreCase(categoryEntity.getCategoryDisplay()) || categoryEntity.getCategoryType().equals(CategoryTypeEnum.LINK.toString()) || categoryEntity.getCategoryType().equals(CategoryTypeEnum.COVER.toString())) continue;
            contentBean.setCategoryId(categoryEntity.getId());
            contentBean.setCategoryType(categoryEntity.getCategoryType());
            contentBean.setOrderBy("date");
            articleIdList = this.contentBiz.queryIdsByCategoryIdForParser(contentBean);
            if (!categoryEntity.getCategoryType().equals(CategoryTypeEnum.LIST.toString())) continue;
            if (!FileUtil.exist((String)ParserUtil.buildTemplatePath((String)categoryEntity.getCategoryListUrl())) || StringUtils.isEmpty((CharSequence)categoryEntity.getCategoryListUrl())) {
                this.LOG.error("{} \u6a21\u677f\u4e0d\u5b58\u5728\uff1a{}", (Object)categoryEntity.getCategoryTitle(), (Object)categoryEntity.getCategoryListUrl());
                continue;
            }
            if (articleIdList.size() <= 0) continue;
            CmsParserUtil.generateBasic(articleIdList, this.htmlDir, (Date)contentUpdateTime);
        }
        return ResultData.build().success();
    }

    @Operation(summary="\u9884\u89c8\u4e3b\u9875\u63a5\u53e3")
    @RequestMapping(value={"/{position}/viewIndex"}, method={RequestMethod.GET, RequestMethod.POST})
    public String viewIndex(HttpServletRequest request, @PathVariable String position, HttpServletResponse response) {
        AppEntity app = BasicUtil.getApp();
        String indexPosition = app.getAppHostUrl() + this.htmlDir + File.separator + app.getAppDir() + File.separator + position + ".html";
        return "redirect:" + indexPosition;
    }

    @Operation(summary="\u5220\u9664\u9875\u9762")
    @Parameter(name="fileName", description="\u4e3b\u9875\u540d\u79f0", required=true, in=ParameterIn.QUERY)
    @LogAnn(title="\u5220\u9664\u9875\u9762", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"cms:generate:del"})
    public ResultData delete(HttpServletRequest request) {
        String deletePath = BasicUtil.getString((String)"deletePath");
        if (StrUtil.isBlank((CharSequence)deletePath)) {
            return ResultData.build().error("\u8bf7\u5148\u8f93\u5165\u8981\u5220\u9664\u7684\u6587\u4ef6\u8def\u5f84");
        }
        if (!deletePath.startsWith(this.htmlDir) && !deletePath.startsWith("/" + this.htmlDir)) {
            return ResultData.build().error("\u5220\u9664\u8def\u5f84\u8bf7\u4ee5" + this.htmlDir + "\u5f00\u5934");
        }
        if (deletePath.contains("..") || deletePath.contains("../") || deletePath.contains("..\\")) {
            return ResultData.build().error("\u975e\u6cd5\u8def\u5f84");
        }
        String appDir = BasicUtil.getApp().getAppDir();
        String realPath = BasicUtil.getRealPath((String)deletePath);
        String webRealPath = BasicUtil.getRealPath((String)(this.htmlDir + "/" + appDir + "/"));
        String htmlRealPath = BasicUtil.getRealPath((String)this.htmlDir);
        List paths = FileUtil.listFileNames((String)htmlRealPath);
        if (CollUtil.isEmpty((Collection)paths) && !realPath.startsWith(webRealPath)) {
            return ResultData.build().error("\u4e0d\u5141\u8bb8\u8de8\u7ad9\u5220\u9664");
        }
        if (FileUtil.exist((String)realPath)) {
            FileUtil.del((String)realPath);
            return ResultData.build().success();
        }
        return ResultData.build().error("\u6587\u4ef6\u4e0d\u5b58\u5728");
    }
}

