/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.baidu.ueditor.define.BaseState;
import io.github.xcodeding.UeditorActionEnter;
import jakarta.servlet.http.HttpServletRequest;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.util.BundleUtil;
import net.mingsoft.basic.action.BaseFileAction;
import net.mingsoft.basic.bean.UploadConfigBean;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.service.IUploadBaseService;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.config.MSProperties;
import net.mingsoft.mdiy.util.ConfigUtil;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class BaseAction
extends BaseFileAction {
    protected String getResString(String key) {
        return this.getResString(key, "");
    }

    protected String getResString(String key, String ... params) {
        String str = "";
        try {
            str = super.getResString(key);
            for (int i = 0; i < params.length; ++i) {
                str = str.replace("{" + i + "}", params[i]);
            }
        }
        catch (MissingResourceException e) {
            str = BundleUtil.getString((String)"net.mingsoft.cms.resources.resources", (String)key, (String[])params);
        }
        return str;
    }

    public String exec(HttpServletRequest request, MultipartFile upfile, Map execFileConfigMap, String version) {
        String uploadFolderPath = MSProperties.upload.path;
        String uploadMapping = MSProperties.upload.mapping;
        Map uploadConfig = ConfigUtil.getMap((String)"\u6587\u4ef6\u4e0a\u4f20\u914d\u7f6e");
        if (MapUtil.isNotEmpty((Map)uploadConfig)) {
            uploadFolderPath = uploadConfig.get("uploadPath").toString();
            uploadMapping = uploadConfig.get("uploadMapping").toString();
        }
        String rootPath = FileUtil.isAbsolutePath((String)uploadFolderPath) ? uploadFolderPath : BasicUtil.getRealPath((String)uploadFolderPath);
        HashMap<String, String> execConfigMap = new HashMap<String, String>();
        execConfigMap.putAll(execFileConfigMap);
        AppEntity app = BasicUtil.getApp();
        String datePath = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        String uploadPath = "/".concat(app.getAppId()).concat("/editor/").concat(datePath).concat("/");
        String filePathFormat = uploadPath.concat("{time}");
        execConfigMap.put("imagePathFormat", filePathFormat);
        execConfigMap.put("filePathFormat", filePathFormat);
        execConfigMap.put("videoPathFormat", filePathFormat);
        execConfigMap.put("catcherPathFormat", filePathFormat);
        execConfigMap.put("scrawlPathFormat", filePathFormat);
        execConfigMap.put("snapscreenPathFormat", filePathFormat);
        String execConfig = JSONUtil.toJsonStr(execConfigMap);
        if (upfile != null) {
            BaseState state = null;
            String upFileMainName = FileNameUtil.mainName((String)upfile.getOriginalFilename());
            if (StringUtils.isBlank((CharSequence)upFileMainName)) {
                return new BaseState(false, this.getResString("err.error", this.getResString("file.name"))).toJSONString();
            }
            UploadConfigBean bean = new UploadConfigBean(uploadPath, upfile, null, true);
            bean.setFileSize(upfile.getSize());
            bean.setFileName(upfile.getOriginalFilename());
            try {
                String type = ConfigUtil.getString((String)"\u5b58\u50a8\u8bbe\u7f6e", (String)"storeSelect");
                IUploadBaseService uploadBaseService = null;
                if (StringUtils.isNotBlank((CharSequence)type)) {
                    if (StringUtils.isBlank((CharSequence)bean.getFileIdentifier())) {
                        try {
                            bean.setFileIdentifier(String.valueOf(Hex.encodeHex((byte[])MessageDigest.getInstance("MD5").digest(bean.getFile().getBytes()))));
                        }
                        catch (NoSuchAlgorithmException e) {
                            e.printStackTrace();
                        }
                    }
                    uploadBaseService = (IUploadBaseService)SpringUtil.getBean((String)type);
                }
                ResultData resultData = null;
                resultData = uploadBaseService != null ? uploadBaseService.upload(bean) : this.upload(bean);
                if (resultData.isSuccess()) {
                    state = new BaseState(true);
                    state.putInfo("original", upfile.getOriginalFilename());
                    state.putInfo("size", upfile.getSize());
                    state.putInfo("title", FileNameUtil.getName((String)((String)resultData.getData(String.class))));
                    state.putInfo("type", "." + FileNameUtil.getSuffix((String)upfile.getOriginalFilename()));
                    state.putInfo("fileIdentifier", bean.getFileIdentifier());
                    String contextPath = BasicUtil.getContextPath();
                    Object filePath = (String)resultData.getData(String.class);
                    if (StringUtils.isNotBlank((CharSequence)filePath) && !((String)filePath).startsWith("http")) {
                        filePath = (contextPath.equals("/") ? "" : contextPath) + (String)filePath;
                    }
                    state.putInfo("url", (String)filePath);
                } else {
                    state = new BaseState(false, resultData.getMsg());
                }
                return state.toJSONString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return new BaseState(false, 500).toJSONString();
            }
        }
        if (execConfig != null && (execConfig.contains("../") || execConfig.contains("..\\"))) {
            return new BaseState(false, BundleUtil.getString((String)"net.mingsoft.base.resources.resources", (String)"err.error", (String[])new String[]{BundleUtil.getString((String)"net.mingsoft.basic.resources.resources", (String)"file.path", (String[])new String[0])})).toJSONString();
        }
        UeditorActionEnter actionEnter = new UeditorActionEnter(upfile, request, rootPath, execConfig, BasicUtil.getRealPath((String)""), BasicUtil.getRealPath((String)StrUtil.format((CharSequence)"static/plugins/ueditor/{}/config.json", (Object[])new Object[]{version})));
        String result = actionEnter.exec();
        Map jsonMap = (Map)JSONUtil.toBean((String)result, Map.class);
        jsonMap.put("url", "/".concat(uploadMapping.replaceAll("/([\\s\\S]*)/\\*\\*", "$1")).concat("" + jsonMap.get("url")));
        return JSONUtil.toJsonStr((Object)jsonMap);
    }
}

