/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.util.SqlInjectionUtil;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.cms.action.BaseAction;
import net.mingsoft.cms.bean.ContentBean;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.biz.IContentBiz;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.cms.entity.ContentEntity;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.entity.ModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u5185\u5bb9\u6a21\u5757\u63a5\u53e3")
@Controller(value="cmsContentAction")
@RequestMapping(value={"/${ms.manager.path}/cms/content"})
public class ContentAction
extends BaseAction {
    @Autowired
    private IContentBiz contentBiz;
    @Autowired
    private ICategoryBiz categoryBiz;
    @Resource(name="mdiyModelBizImpl")
    private IModelBiz modelBiz;

    @Hidden
    @GetMapping(value={"/index"})
    public String index() {
        return "/cms/content/index";
    }

    @Hidden
    @GetMapping(value={"/main"})
    public String main() {
        return "/cms/content/main";
    }

    @Operation(summary="\u67e5\u8be2\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="contentTitle", description="\u6587\u7ae0\u6807\u9898", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryId", description="\u6240\u5c5e\u680f\u76ee", required=false, in=ParameterIn.QUERY), @Parameter(name="contentType", description="\u6587\u7ae0\u7c7b\u578b", required=false, in=ParameterIn.QUERY), @Parameter(name="contentDisplay", description="\u662f\u5426\u663e\u793a,0:\u663e\u793a 1:\u4e0d\u663e\u793a", required=false, in=ParameterIn.QUERY), @Parameter(name="contentAuthor", description="\u6587\u7ae0\u4f5c\u8005", required=false, in=ParameterIn.QUERY), @Parameter(name="contentSource", description="\u6587\u7ae0\u6765\u6e90", required=false, in=ParameterIn.QUERY), @Parameter(name="contentDatetime", description="\u53d1\u5e03\u65f6\u95f4", required=false, in=ParameterIn.QUERY)})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    @RequiresPermissions(value={"cms:content:view"})
    public ResultData list(@ModelAttribute @Parameter(hidden=true) ContentBean content) {
        SqlInjectionUtil.filterContent((String[])new String[]{content.getCategoryId()});
        BasicUtil.startPage();
        List<ContentBean> contentList = this.contentBiz.queryContent(content);
        return ResultData.build().success((Object)new EUListBean(contentList, (int)BasicUtil.endPage(contentList).getTotal()));
    }

    @Hidden
    @GetMapping(value={"/form"})
    public String form(@ModelAttribute ContentEntity content, ModelMap model) {
        model.addAttribute("appId", (Object)BasicUtil.getApp().getAppId());
        return "/cms/content/form";
    }

    @Operation(summary="\u83b7\u53d6\u6587\u7ae0\u8be6\u60c5\u63a5\u53e3")
    @Parameter(name="id", description="\u7f16\u53f7", required=true, in=ParameterIn.QUERY)
    @GetMapping(value={"/get"})
    @ResponseBody
    @RequiresPermissions(value={"cms:content:view"})
    public ResultData get(@ModelAttribute @Parameter(hidden=true) ContentEntity content) {
        if (content.getId() == null) {
            return ResultData.build().error();
        }
        ContentEntity _content = (ContentEntity)((Object)this.contentBiz.getById((Serializable)((Object)content.getId())));
        return ResultData.build().success((Object)_content);
    }

    @Operation(summary="\u6839\u636e\u5c01\u9762\u83b7\u53d6\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @Parameter(name="categoryId", description="\u5206\u7c7b\u7f16\u53f7", required=true, in=ParameterIn.QUERY)
    @GetMapping(value={"/getFromFengMian"})
    @ResponseBody
    public ResultData getFromFengMian(@ModelAttribute @Parameter(hidden=true) ContentEntity content) {
        if (StringUtils.isBlank((CharSequence)content.getCategoryId())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("category.id")));
        }
        List list = ((LambdaQueryChainWrapper)this.contentBiz.lambdaQuery().eq(ContentEntity::getCategoryId, (Object)content.getCategoryId())).list();
        if (list.size() > 1) {
            this.LOG.error("\u83b7\u53d6\u5c01\u9762\u6587\u7ae0\u5f02\u5e38");
        }
        return ResultData.build().success(list.size() > 0 ? list.get(0) : null);
    }

    @Operation(summary="\u4fdd\u5b58\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="contentTitle", description="\u6587\u7ae0\u6807\u9898", required=true, in=ParameterIn.QUERY), @Parameter(name="categoryId", description="\u6240\u5c5e\u680f\u76ee", required=true, in=ParameterIn.QUERY), @Parameter(name="contentType", description="\u6587\u7ae0\u7c7b\u578b", required=false, in=ParameterIn.QUERY), @Parameter(name="contentDisplay", description="\u662f\u5426\u663e\u793a,0:\u663e\u793a 1:\u4e0d\u663e\u793a", required=true, in=ParameterIn.QUERY), @Parameter(name="contentAuthor", description="\u6587\u7ae0\u4f5c\u8005", required=false, in=ParameterIn.QUERY), @Parameter(name="contentSource", description="\u6587\u7ae0\u6765\u6e90", required=false, in=ParameterIn.QUERY), @Parameter(name="contentDatetime", description="\u53d1\u5e03\u65f6\u95f4", required=true, in=ParameterIn.QUERY), @Parameter(name="contentSort", description="\u81ea\u5b9a\u4e49\u987a\u5e8f", required=false, in=ParameterIn.QUERY), @Parameter(name="contentImg", description="\u6587\u7ae0\u7f29\u7565\u56fe", required=false, in=ParameterIn.QUERY), @Parameter(name="contentDescription", description="\u63cf\u8ff0", required=false, in=ParameterIn.QUERY), @Parameter(name="contentKeyword", description="\u5173\u952e\u5b57", required=false, in=ParameterIn.QUERY), @Parameter(name="contentDetails", description="\u6587\u7ae0\u5185\u5bb9", required=false, in=ParameterIn.QUERY), @Parameter(name="contentOutLink", description="\u6587\u7ae0\u8df3\u8f6c\u94fe\u63a5\u5730\u5740", required=false, in=ParameterIn.QUERY)})
    @PostMapping(value={"/save"})
    @ResponseBody
    @LogAnn(title="\u4fdd\u5b58\u6587\u7ae0", businessType=BusinessTypeEnum.INSERT)
    @RequiresPermissions(value={"cms:content:save"})
    public ResultData save(@ModelAttribute @Parameter(hidden=true) ContentEntity content) {
        if (content.getContentImg() == null || !content.getContentImg().matches("^\\[.{1,}]$")) {
            content.setContentImg("");
        }
        if (StringUtil.isBlank((Object)content.getContentTitle())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("content.title")));
        }
        if (!StringUtil.checkLength((String)(content.getContentTitle() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.title"), "0", "200"));
        }
        if (!StringUtil.checkLength((String)(content.getContentAuthor() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.author"), "0", "200"));
        }
        if (!StringUtil.checkLength((String)(content.getContentSource() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.source"), "0", "200"));
        }
        if (!StringUtil.checkLength((String)(content.getContentDescription() + ""), (int)0, (int)400)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.description"), "0", "400"));
        }
        if (!StringUtil.checkLength((String)(content.getContentOutLink() + ""), (int)0, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.url"), "0", "255"));
        }
        if (!StringUtil.checkLength((String)(content.getContentDisplay() + ""), (int)0, (int)1)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.display"), "0", "1"));
        }
        if (!StringUtil.checkLength((String)(content.getContentKeyword() + ""), (int)0, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.keyword"), "0", "255"));
        }
        if (!StringUtil.checkLength((String)(content.getContentType() + ""), (int)0, (int)20)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.type"), "0", "20"));
        }
        if (StringUtil.isBlank((Object)content.getContentDatetime())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("content.datetime")));
        }
        this.contentBiz.save((Object)content);
        return ResultData.build().success((Object)content);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="contents", description="\u6587\u7ae0\u96c6\u5408", schema=@Schema(allOf={ContentEntity.class}), required=true)})
    @PostMapping(value={"/delete"})
    @ResponseBody
    @LogAnn(title="\u5220\u9664\u6587\u7ae0", businessType=BusinessTypeEnum.DELETE)
    @RequiresPermissions(value={"cms:content:del"})
    public ResultData delete(@RequestBody List<ContentEntity> contents) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < contents.size(); ++i) {
            ids.add(contents.get(i).getId());
            CategoryEntity categoryEntity = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)contents.get(i).getCategoryId())));
            if (StringUtils.isBlank((CharSequence)categoryEntity.getMdiyModelId())) continue;
            ModelEntity modelEntity = this.modelBiz.getById((Serializable)((Object)categoryEntity.getMdiyModelId()));
            SqlInjectionUtil.filterContent((String[])new String[]{modelEntity.getModelTableName()});
            this.modelBiz.update(StrUtil.format((CharSequence)"delete from {} where link_id = ?", (Object[])new Object[]{modelEntity.getModelTableName()}), new Object[]{contents.get(i).getId()});
        }
        this.contentBiz.removeByIds(ids);
        return ResultData.build().success();
    }

    @Operation(summary="\u66f4\u65b0\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="id", description="\u7f16\u53f7", required=true, in=ParameterIn.QUERY), @Parameter(name="contentTitle", description="\u6587\u7ae0\u6807\u9898", required=true, in=ParameterIn.QUERY), @Parameter(name="categoryId", description="\u6240\u5c5e\u680f\u76ee", required=true, in=ParameterIn.QUERY), @Parameter(name="contentType", description="\u6587\u7ae0\u7c7b\u578b", required=false, in=ParameterIn.QUERY), @Parameter(name="contentDisplay", description="\u662f\u5426\u663e\u793a,0:\u663e\u793a 1:\u4e0d\u663e\u793a", required=true, in=ParameterIn.QUERY), @Parameter(name="contentAuthor", description="\u6587\u7ae0\u4f5c\u8005", required=false, in=ParameterIn.QUERY), @Parameter(name="contentSource", description="\u6587\u7ae0\u6765\u6e90", required=false, in=ParameterIn.QUERY), @Parameter(name="contentDatetime", description="\u53d1\u5e03\u65f6\u95f4", required=true, in=ParameterIn.QUERY), @Parameter(name="contentSort", description="\u81ea\u5b9a\u4e49\u987a\u5e8f", required=false, in=ParameterIn.QUERY), @Parameter(name="contentImg", description="\u6587\u7ae0\u7f29\u7565\u56fe", required=false, in=ParameterIn.QUERY), @Parameter(name="contentDescription", description="\u63cf\u8ff0", required=false, in=ParameterIn.QUERY), @Parameter(name="contentKeyword", description="\u5173\u952e\u5b57", required=false, in=ParameterIn.QUERY), @Parameter(name="contentDetails", description="\u6587\u7ae0\u5185\u5bb9", required=false, in=ParameterIn.QUERY), @Parameter(name="contentOutLink", description="\u6587\u7ae0\u8df3\u8f6c\u94fe\u63a5\u5730\u5740", required=false, in=ParameterIn.QUERY)})
    @PostMapping(value={"/update"})
    @ResponseBody
    @LogAnn(title="\u66f4\u65b0\u6587\u7ae0", businessType=BusinessTypeEnum.UPDATE)
    @RequiresPermissions(value={"cms:content:update"})
    public ResultData update(@ModelAttribute @Parameter(hidden=true) ContentEntity content) {
        if (content.getContentImg() == null || !content.getContentImg().matches("^\\[.{1,}]$")) {
            content.setContentImg("");
        }
        if (StringUtil.isBlank((Object)content.getContentTitle())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("content.title")));
        }
        if (!StringUtil.checkLength((String)(content.getContentTitle() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.title"), "0", "200"));
        }
        if (!StringUtil.checkLength((String)(content.getContentAuthor() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.author"), "0", "200"));
        }
        if (!StringUtil.checkLength((String)(content.getContentSource() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.source"), "0", "200"));
        }
        if (!StringUtil.checkLength((String)(content.getContentDescription() + ""), (int)0, (int)400)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.description"), "0", "400"));
        }
        if (!StringUtil.checkLength((String)(content.getContentOutLink() + ""), (int)0, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.url"), "0", "255"));
        }
        if (!StringUtil.checkLength((String)(content.getContentDisplay() + ""), (int)0, (int)1)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.display"), "0", "1"));
        }
        if (!StringUtil.checkLength((String)(content.getContentKeyword() + ""), (int)0, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.keyword"), "0", "255"));
        }
        if (!StringUtil.checkLength((String)(content.getContentType() + ""), (int)0, (int)20)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("content.type"), "0", "20"));
        }
        if (StringUtil.isBlank((Object)content.getContentDatetime())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("content.datetime")));
        }
        this.contentBiz.saveOrUpdate((Object)content);
        return ResultData.build().success((Object)content);
    }
}

