/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.PageUtil;
import freemarker.core.ParseException;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.cms.bean.CategoryBean;
import net.mingsoft.cms.constant.e.CategoryTypeEnum;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.mdiy.bean.PageBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.biz.impl.ModelBizImpl;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.util.ParserUtil;
import org.apache.commons.lang3.StringUtils;

public class CmsParserUtil
extends ParserUtil {
    private static final String FIELD = "field";

    public static void generate(String templatePath, String targetPath, String htmlDir) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isDo", false);
        CategoryEntity column = new CategoryEntity();
        map.put("column", (Object)column);
        String content = CmsParserUtil.generate((String)templatePath, map, (String)htmlDir);
        FileUtil.writeString((String)content, (String)ParserUtil.buildHtmlPath((String)targetPath, (String)htmlDir), (String)"utf-8");
    }

    public static void generateList(CategoryEntity column, int articleIdTotal, String htmlDir) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        try {
            PageBean page = new PageBean();
            page.setSize(ParserUtil.getPageSize((String)column.getCategoryListUrl(), (int)20));
            page.setRcount(articleIdTotal);
            int totalPageSize = PageUtil.totalPage((int)articleIdTotal, (int)page.getSize());
            page.setTotal(totalPageSize);
            HashMap<String, String> map = new HashMap<String, String>();
            if (BasicUtil.getWebsiteApp() != null) {
                map.put("appDir", BasicUtil.getWebsiteApp().getAppDir());
            }
            map.put("html", htmlDir);
            map.put("url", BasicUtil.getUrl());
            map.put("pageTag", (String)page);
            ModelEntity contentModel = null;
            if (column.getMdiyModelId() != null) {
                contentModel = (ModelEntity)((ModelBizImpl)SpringUtil.getBean(ModelBizImpl.class)).getEntity(column.getMdiyModelId().intValue());
            }
            HashMap<String, Object> parserParams = new HashMap<String, Object>();
            parserParams.put("pageTag", page);
            parserParams.put("column", (Object)column);
            parserParams.put(FIELD, (Object)column);
            parserParams.put("isDo", false);
            parserParams.put("html", htmlDir);
            if (BasicUtil.getWebsiteApp() != null) {
                parserParams.put("appDir", BasicUtil.getWebsiteApp().getAppDir());
            }
            if (contentModel != null) {
                parserParams.put("tableName", contentModel.getModelTableName());
            }
            if (ParserUtil.IS_SINGLE) {
                parserParams.put("url", BasicUtil.getUrl());
            }
            int pageNo = 1;
            if (totalPageSize <= 0) {
                String columnListPath = ParserUtil.buildHtmlPath((String)(column.getCategoryPath() + File.separator + "index"), (String)htmlDir);
                page.setPageNo(pageNo);
                String read = ParserUtil.rendering((String)(File.separator + column.getCategoryListUrl()), parserParams);
                FileUtil.writeString((String)read, (String)columnListPath, (String)"utf-8");
            } else {
                for (int i = 0; i < totalPageSize; ++i) {
                    String columnListPath = i == 0 ? ParserUtil.buildHtmlPath((String)(column.getCategoryPath() + File.separator + "index"), (String)htmlDir) : ParserUtil.buildHtmlPath((String)(column.getCategoryPath() + File.separator + "list-" + pageNo), (String)htmlDir);
                    page.setPageNo(pageNo);
                    String read = ParserUtil.rendering((String)(File.separator + column.getCategoryListUrl()), parserParams);
                    FileUtil.writeString((String)read, (String)columnListPath, (String)"utf-8");
                    ++pageNo;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateBasic(List<CategoryBean> articleIdList, String htmlDir) {
        HashMap<Integer, String> contentModelMap = new HashMap<Integer, String>();
        ModelEntity contentModel = null;
        ArrayList<String> generateIds = new ArrayList<String>();
        ExecutorService pool = (ExecutorService)SpringUtil.getBean(ExecutorService.class);
        int artId = 0;
        while (artId < articleIdList.size()) {
            CategoryBean categoryBean = articleIdList.get(artId);
            String writePath = null;
            PageBean page = new PageBean();
            String articleId = categoryBean.getArticleId();
            String articleColumnPath = categoryBean.getCategoryPath();
            String categoryParentId = categoryBean.getId();
            if (StringUtils.isNotBlank((CharSequence)categoryBean.getCategoryParentIds())) {
                categoryParentId = categoryParentId + ',' + categoryBean.getCategoryParentIds();
            }
            String columnUrl = categoryBean.getCategoryUrl();
            Integer columnContentModelId = null;
            if (articleIdList.get(artId).getMdiyModelId() != null && categoryBean.getMdiyModelId() > 0) {
                columnContentModelId = categoryBean.getMdiyModelId();
            }
            if (generateIds.contains(articleId)) {
                ++artId;
                continue;
            }
            if (!FileUtil.exist((String)ParserUtil.buildTempletPath((String)columnUrl)) || categoryBean.getId() == null || categoryBean.getCategoryType() == null) {
                ++artId;
                continue;
            }
            generateIds.add(articleId);
            writePath = categoryBean.getCategoryType().equals(CategoryTypeEnum.COVER.toString()) ? ParserUtil.buildHtmlPath((String)(articleColumnPath + File.separator + "index"), (String)htmlDir) : ParserUtil.buildHtmlPath((String)(articleColumnPath + File.separator + articleId), (String)htmlDir);
            HashMap<String, Object> parserParams = new HashMap<String, Object>();
            parserParams.put("column", (Object)categoryBean);
            if (columnContentModelId != null) {
                if (contentModelMap.containsKey(columnContentModelId)) {
                    parserParams.put("tableName", contentModel.getModelTableName());
                } else {
                    contentModel = (ModelEntity)((IModelBiz)SpringUtil.getBean(IModelBiz.class)).getEntity(columnContentModelId.intValue());
                    contentModelMap.put(columnContentModelId, contentModel.getModelTableName());
                    parserParams.put("tableName", contentModel.getModelTableName());
                }
            }
            parserParams.put("id", articleId);
            if (artId > 0) {
                CategoryBean preCaBean = articleIdList.get(artId - 1);
                page.setPreId(preCaBean.getArticleId());
            }
            if (artId + 1 < articleIdList.size()) {
                CategoryBean nextCaBean = articleIdList.get(artId + 1);
                page.setNextId(nextCaBean.getArticleId());
            }
            parserParams.put("isDo", false);
            parserParams.put("pageTag", page);
            String finalWritePath = writePath;
            HashMap cloneMap = CollUtil.newHashMap();
            cloneMap.putAll(parserParams);
            HttpServletRequest request = SpringUtil.getRequest();
            pool.execute(() -> {
                String content = null;
                try {
                    SpringUtil.setRequest((HttpServletRequest)request);
                    content = CmsParserUtil.generate((String)columnUrl, (Map)cloneMap, (String)htmlDir);
                    FileUtil.writeString((String)content, (String)finalWritePath, (String)"utf-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            ++artId;
        }
    }
}

