/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.aop;

import java.util.Date;
import net.mingsoft.basic.aop.BaseAop;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.cms.biz.IContentBiz;
import net.mingsoft.cms.biz.IHistoryLogBiz;
import net.mingsoft.cms.entity.ContentEntity;
import net.mingsoft.cms.entity.HistoryLogEntity;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class CotentAop
extends BaseAop {
    @Autowired
    private IContentBiz contentBiz;
    @Autowired
    private IHistoryLogBiz historyLogBiz;

    @Around(value="execution(* net.mingsoft.cms.action.web.ContentAction.get(..))")
    public Object get(ProceedingJoinPoint pjp) throws Throwable {
        ContentEntity content = (ContentEntity)((Object)this.getType((JoinPoint)pjp, ContentEntity.class));
        if (content.getId() == null) {
            return pjp.proceed();
        }
        if ((content = (ContentEntity)this.contentBiz.getEntity(Integer.parseInt(content.getId()))) == null) {
            return pjp.proceed();
        }
        HistoryLogEntity historyLog = new HistoryLogEntity();
        historyLog.setContentId(content.getId());
        historyLog.setHlIp(BasicUtil.getIp());
        historyLog.setHlIsMobile(BasicUtil.isMobileDevice());
        HistoryLogEntity _historyLog = (HistoryLogEntity)((Object)this.historyLogBiz.getEntity(historyLog));
        if (_historyLog == null || StringUtils.isBlank((CharSequence)_historyLog.getId())) {
            historyLog.setCreateDate(new Date());
            this.historyLogBiz.saveEntity(historyLog);
            ContentEntity updateContent = new ContentEntity();
            updateContent.setId(content.getId());
            if (content.getContentHit() == null) {
                updateContent.setContentHit(1);
            } else {
                updateContent.setContentHit(content.getContentHit() + 1);
            }
            this.contentBiz.updateEntity(updateContent);
        }
        return pjp.proceed();
    }
}

