/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action.web;

import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="indexAction")
@RequestMapping(value={"index"})
public class IndexAction {
    private static String INDEX = "index.html";
    private static String DEFAULT = "default.html";
    private IAppBiz appBiz;

    @ApiOperation(value="\u8bbf\u95ee\u7ad9\u70b9\u4e3b\u9875")
    @RequestMapping
    public String index(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.appBiz = SpringUtil.getBean(IAppBiz.class);
        int websiteId = 0;
        AppEntity website = this.appBiz.getByUrl(BasicUtil.getDomain());
        if (website == null) {
            return "";
        }
        websiteId = website.getAppId();
        String path = "";
        if (!StringUtils.isEmpty((CharSequence)website.getAppMobileStyle())) {
            path = BasicUtil.isMobileDevice() ? "m" : "";
        }
        String defaultHtmlPath = BasicUtil.getRealPath("html" + File.separator + websiteId + File.separator + path + File.separator + "default.html");
        File file = new File(defaultHtmlPath);
        String url = "html/" + websiteId + "/" + path;
        String indexPosition = url + "/" + INDEX;
        if (file.exists()) {
            indexPosition = url + "/" + DEFAULT;
        }
        return "forward:" + indexPosition;
    }
}

