/*
 * Decompiled with CFR 0.152.
 */
package net.micwin.tindata;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.micwin.tindata.DispatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinData {
    static Map<Class<?>, List<ReceiverDescriptor>> receiverMap = new HashMap();

    public static synchronized void register(Class<?> eventClass, Object receiver) {
        Method method = TinData.detectReceiverMethod(receiver, eventClass);
        TinData.registerInternal(receiver, method, eventClass);
    }

    private static void registerInternal(Object receiver, Method method, Class<?> eventClass) {
        List<ReceiverDescriptor> receivers = receiverMap.get(eventClass);
        if (receivers == null) {
            receivers = new LinkedList<ReceiverDescriptor>();
            receiverMap.put(eventClass, receivers);
        }
        ReceiverDescriptor rd = new ReceiverDescriptor();
        rd.receiverReference = new WeakReference<Object>(receiver);
        rd.method = method;
        receivers.add(rd);
    }

    private static Method detectReceiverMethod(Object receiver, Class<?> eventClass) {
        Method[] methods = receiver.getClass().getMethods();
        LinkedList<Method> results = new LinkedList<Method>();
        for (Method method : methods) {
            if (method.getParameterTypes() == null || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(eventClass) || "equals".equals(method.getName())) continue;
            results.add(method);
        }
        if (results.size() == 1) {
            return (Method)results.get(0);
        }
        if (results.size() > 1) {
            throw new IllegalArgumentException("receiver '" + receiver + "' has more that one accessible method with a single parameter of type '" + eventClass.getName() + "' : " + ((Object)results).toString());
        }
        throw new IllegalArgumentException("receiver '" + receiver + "' does not have an accessible method with a single parameter of type '" + eventClass.getName() + "'");
    }

    public static synchronized void dispatch(Object event) {
        List<ReceiverDescriptor> receivers = receiverMap.get(event.getClass());
        if (receivers == null || receivers.size() < 1) {
            return;
        }
        LinkedList<ReceiverDescriptor> defunct = new LinkedList<ReceiverDescriptor>();
        for (ReceiverDescriptor receiverDescriptor : receivers) {
            Object receiver = receiverDescriptor.receiverReference.get();
            if (receiver == null) {
                defunct.add(receiverDescriptor);
                continue;
            }
            try {
                receiverDescriptor.method.setAccessible(true);
                receiverDescriptor.method.invoke(receiver, event);
            }
            catch (Exception e) {
                throw new DispatchException(receiver, event, e);
            }
        }
        receivers.removeAll(defunct);
    }

    private static class ReceiverDescriptor {
        WeakReference<Object> receiverReference;
        Method method;

        private ReceiverDescriptor() {
        }
    }
}

