/*
 * Decompiled with CFR 0.152.
 */
package net.mediavrog.irr;

import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import net.mediavrog.irr.DefaultOnToggleVisibilityListener;
import net.mediavrog.irr.DefaultOnUserActionListener;
import net.mediavrog.irr.DefaultRuleEngine;
import net.mediavrog.irr.R;
import net.mediavrog.ruli.RuleEngine;

public class IrrLayout
extends FrameLayout {
    public static final String TAG = IrrLayout.class.getSimpleName();
    private static final int[] DEFAULT_ATTRS = new int[]{16843506};
    private static final int mNudgeLayoutResId = R.id.irr_nudge_layout;
    private static final int mRateLayoutResId = R.id.irr_rate_layout;
    private static final int mFeedbackLayoutResId = R.id.irr_feedback_layout;
    private static final int mNudgeAcceptBtnResId = R.id.irr_nudge_accept_btn;
    private static final int mNudgeDeclineBtnResId = R.id.irr_nudge_decline_btn;
    private static final int mRateAcceptBtnResId = R.id.irr_rate_accept_btn;
    private static final int mRateDeclineBtnResId = R.id.irr_rate_decline_btn;
    private static final int mFeedbackAcceptBtnResId = R.id.irr_feedback_accept_btn;
    private static final int mFeedbackDeclineBtnResId = R.id.irr_feedback_decline_btn;
    private boolean mUseCustomEngine;
    private String mRatingUrl = null;
    private String mFeedbackUrl = null;
    private View mNudgeView = null;
    private View mRateView = null;
    private View mFeedbackView = null;
    private RuleEngine mRuleEngine = null;
    private OnUserDecisionListener mDecisionListener = null;
    private OnUserActionListener mActionListener = null;
    private OnToggleVisibilityListener mVisibilityListener = null;
    private boolean mIsAttached;

    public IrrLayout(Context context) {
        this(context, null);
    }

    public IrrLayout(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public IrrLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray ta;
            TypedArray defAttrs = context.obtainStyledAttributes(attrs, DEFAULT_ATTRS);
            if (defAttrs != null) {
                boolean animateLayoutChanges = defAttrs.getBoolean(0, true);
                if (animateLayoutChanges) {
                    this.setLayoutTransition(new LayoutTransition());
                }
                defAttrs.recycle();
            }
            if ((ta = context.obtainStyledAttributes(attrs, R.styleable.IrrLayout)) != null) {
                this.mRatingUrl = ta.getString(R.styleable.IrrLayout_ratingUrl);
                this.mFeedbackUrl = ta.getString(R.styleable.IrrLayout_feedbackUrl);
                if (this.mRatingUrl != null || this.mFeedbackUrl != null) {
                    this.mActionListener = new DefaultOnUserActionListener(this.mRatingUrl, this.mFeedbackUrl);
                }
                this.mUseCustomEngine = ta.getBoolean(R.styleable.IrrLayout_useCustomRuleEngine, false);
                if (!this.mUseCustomEngine) {
                    this.setupDefaultRuleEngine(context, ta);
                }
                ta.recycle();
            }
        }
        this.mVisibilityListener = new DefaultOnToggleVisibilityListener();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initializeStates();
        this.enableFlowControls();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mIsAttached) {
            this.mIsAttached = true;
            this.toggleTo(this.mRuleEngine != null && this.mRuleEngine.isReady() && this.mRuleEngine.isValid());
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsAttached = false;
    }

    public void setOnUserDecisionListener(OnUserDecisionListener l) {
        this.mDecisionListener = l;
    }

    public OnUserDecisionListener getOnUserDecisionListener() {
        return this.mDecisionListener;
    }

    public void setOnToggleVisibilityListener(OnToggleVisibilityListener l) {
        this.mVisibilityListener = l;
    }

    public OnToggleVisibilityListener getOnToggleVisibilityListener() {
        return this.mVisibilityListener;
    }

    public void setOnUserActionListener(OnUserActionListener l) {
        this.mActionListener = l;
    }

    public OnUserActionListener getOnUserActionListener() {
        return this.mActionListener;
    }

    public void setRuleEngine(RuleEngine b) {
        if (!this.mUseCustomEngine) {
            throw new RuntimeException("Cannot set a custom rule engine unless irr:seCustomRuleEngine is set to true, because the default rule engine was already loaded.");
        }
        this.configureEngine(b);
    }

    public RuleEngine getRuleEngine() {
        return this.mRuleEngine;
    }

    void setupDefaultRuleEngine(Context ctx, TypedArray ta) {
        int appStartCount = ta.getInt(R.styleable.IrrLayout_defaultRuleAppStartCount, 10);
        int distinctDays = ta.getInt(R.styleable.IrrLayout_defaultRuleDistinctDays, 3);
        int postponeDays = ta.getInt(R.styleable.IrrLayout_defaultRuleDismissPostponeDays, 6);
        int maxDismissCount = ta.getInt(R.styleable.IrrLayout_defaultRuleDismissMaxCount, 3);
        boolean autoEval = ta.getBoolean(R.styleable.IrrLayout_autoEvaluateDefaultRuleEngine, true);
        DefaultRuleEngine engine = DefaultRuleEngine.newInstance(ctx, appStartCount, distinctDays, postponeDays, maxDismissCount);
        this.setOnUserDecisionListener(engine.getListener());
        this.configureEngine(engine);
        if (autoEval) {
            this.mRuleEngine.evaluate();
        }
    }

    private void configureEngine(RuleEngine b) {
        this.mRuleEngine = b;
        this.mRuleEngine.setOnRulesEvaluatedListener(new RuleEngine.OnRulesEvaluatedListener(){

            public void onResult(boolean isValid) {
                if (!IrrLayout.this.mIsAttached) {
                    return;
                }
                IrrLayout.this.toggleTo(isValid);
            }
        });
    }

    void toggleTo(boolean shouldShow) {
        if (shouldShow) {
            this.show();
        } else {
            this.hide();
        }
    }

    void show() {
        if (this.mVisibilityListener != null) {
            this.mVisibilityListener.onShow(this);
        }
        this.setState(State.NUDGE);
    }

    void hide() {
        if (this.mVisibilityListener != null) {
            this.mVisibilityListener.onHide(this);
        }
    }

    void dismiss(State s) {
        if (this.mDecisionListener != null) {
            this.mDecisionListener.onDismiss(this.getContext(), s);
        }
        this.hide();
    }

    void initializeStates() {
        this.mNudgeView = this.findViewById(mNudgeLayoutResId);
        this.mRateView = this.findViewById(mRateLayoutResId);
        this.mFeedbackView = this.findViewById(mFeedbackLayoutResId);
        if (this.mNudgeView == null || this.mRateView == null || this.mFeedbackView == null) {
            throw new RuntimeException("Please provide all 3 state container views using 'android:id=\"@id/irr_nudge_layout\"' etc.");
        }
        this.setState(State.NUDGE);
    }

    void enableFlowControls() {
        this.findViewById(mNudgeAcceptBtnResId).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (IrrLayout.this.mDecisionListener != null) {
                    IrrLayout.this.mDecisionListener.onDismiss(IrrLayout.this.getContext(), State.NUDGE);
                }
                IrrLayout.this.setState(State.RATE);
            }
        });
        this.findViewById(mNudgeDeclineBtnResId).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (IrrLayout.this.mDecisionListener != null) {
                    IrrLayout.this.mDecisionListener.onAccept(IrrLayout.this.getContext(), State.NUDGE);
                }
                IrrLayout.this.setState(State.FEEDBACK);
            }
        });
        this.findViewById(mRateAcceptBtnResId).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (IrrLayout.this.mDecisionListener != null) {
                    IrrLayout.this.mDecisionListener.onAccept(IrrLayout.this.getContext(), State.RATE);
                }
                if (IrrLayout.this.mActionListener != null) {
                    IrrLayout.this.mActionListener.onRate(IrrLayout.this.getContext());
                }
                IrrLayout.this.hide();
            }
        });
        this.findViewById(mRateDeclineBtnResId).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IrrLayout.this.dismiss(State.RATE);
            }
        });
        this.findViewById(mFeedbackAcceptBtnResId).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (IrrLayout.this.mDecisionListener != null) {
                    IrrLayout.this.mDecisionListener.onAccept(IrrLayout.this.getContext(), State.FEEDBACK);
                }
                if (IrrLayout.this.mActionListener != null) {
                    IrrLayout.this.mActionListener.onFeedback(IrrLayout.this.getContext());
                }
                IrrLayout.this.hide();
            }
        });
        this.findViewById(mFeedbackDeclineBtnResId).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IrrLayout.this.dismiss(State.FEEDBACK);
            }
        });
    }

    void setState(State step) {
        switch (step) {
            case NUDGE: {
                this.mNudgeView.setVisibility(0);
                this.mRateView.setVisibility(8);
                this.mFeedbackView.setVisibility(8);
                break;
            }
            case RATE: {
                this.mNudgeView.setVisibility(8);
                this.mRateView.setVisibility(0);
                this.mFeedbackView.setVisibility(8);
                break;
            }
            case FEEDBACK: {
                this.mNudgeView.setVisibility(8);
                this.mRateView.setVisibility(8);
                this.mFeedbackView.setVisibility(0);
            }
        }
    }

    public static interface OnToggleVisibilityListener {
        public void onShow(IrrLayout var1);

        public void onHide(IrrLayout var1);
    }

    public static interface OnUserActionListener {
        public void onRate(Context var1);

        public void onFeedback(Context var1);
    }

    public static interface OnUserDecisionListener {
        public void onAccept(Context var1, State var2);

        public void onDismiss(Context var1, State var2);
    }

    public static enum State {
        HIDDEN,
        NUDGE,
        RATE,
        FEEDBACK;

    }
}

